/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Legends;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.SaveLegendsEdit;
import info.bioinfweb.treegraph.document.undo.WarningMessageEdit;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class CollapseNodeEdit
extends SaveLegendsEdit
implements WarningMessageEdit {
    private Node node = null;
    private int index = 0;

    public CollapseNodeEdit(Document document, Node node) {
        super(document, DocumentChangeType.TOPOLOGICAL_LEAF_INVARIANT);
        this.node = node;
        if (node.hasParent()) {
            this.index = node.getParent().getChildren().indexOf(node);
        }
    }

    private void editLegends() {
        Legends legends = this.getDocument().getTree().getLegends();
        Node newAnchor = this.node.getParent() != null ? this.node.getParent() : this.node.getChildren().get(0);
        int i = 0;
        while (i < legends.size()) {
            Legend l = legends.get(i);
            if (l.getFormats().getAnchor(0) == this.node) {
                l.getFormats().setAnchor(0, newAnchor);
                this.setLegendsReanchored(true);
            } else if (l.getFormats().getAnchor(1) == this.node) {
                l.getFormats().setAnchor(1, newAnchor);
                this.setLegendsReanchored(true);
            }
            ++i;
        }
    }

    private void editBranchLength(Branch childBranch, double factor) {
        Branch formerParentBranch = this.node.getAfferentBranch();
        if (formerParentBranch.hasLength() && childBranch.hasLength()) {
            childBranch.setLength(childBranch.getLength() + formerParentBranch.getLength() * factor);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        this.saveLegends();
        this.editLegends();
        Node parent = this.node.getParent();
        if (parent != null) {
            int insertIndex = parent.getChildren().indexOf(this.node);
            int i = 0;
            while (i < this.node.getChildren().size()) {
                Node child = this.node.getChildren().get(i);
                child.setParent(parent);
                this.editBranchLength(child.getAfferentBranch(), 1.0);
                parent.getChildren().add(insertIndex + i, child);
                ++i;
            }
            parent.getChildren().remove(this.node);
        } else if (this.node.getChildren().size() == 1) {
            this.node.getChildren().get(0).setParent(null);
            Node child = this.node.getChildren().get(0);
            this.getDocument().getTree().setPaintStart(child);
            this.editBranchLength(child.getAfferentBranch(), 1.0);
        } else {
            throw new IllegalArgumentException("The root node can only be collapsed if it contains exactly one subnode.");
        }
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.node.hasParent()) {
            List<Node> parentChildren = null;
            parentChildren = this.node.getParent().getChildren();
            int i = 0;
            while (i < this.node.getChildren().size()) {
                Node child = this.node.getChildren().get(i);
                child.setParent(this.node);
                if (this.node.hasParent()) {
                    parentChildren.remove(this.node.getChildren().get(i));
                }
                this.editBranchLength(child.getAfferentBranch(), -1.0);
                ++i;
            }
            parentChildren.add(this.index, this.node);
        } else {
            Node child = this.node.getChildren().get(0);
            child.setParent(this.node);
            this.getDocument().getTree().setPaintStart(this.node);
            this.editBranchLength(child.getAfferentBranch(), -1.0);
        }
        this.restoreLegends();
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Collapse node";
    }
}

