/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ChangeLabelIDEdit
extends DocumentEdit {
    private String newID;
    private Label[] labels;
    private String[] oldIDs;

    public ChangeLabelIDEdit(Document document, String newID, Label[] labels) {
        super(document, DocumentChangeType.TOPOLOGICAL_BY_RENAMING);
        this.newID = newID;
        this.labels = labels;
        this.oldIDs = new String[labels.length];
        int i = 0;
        while (i < labels.length) {
            this.oldIDs[i] = labels[i].getID();
            ++i;
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        int i = 0;
        while (i < this.labels.length) {
            this.labels[i].setID(this.newID);
            ++i;
        }
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        int i = 0;
        while (i < this.labels.length) {
            this.labels[i].setID(this.oldIDs[i]);
            ++i;
        }
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Change label ID to \"" + this.newID + "\"";
    }
}

