/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.nodebranchdata.BranchLengthAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.HiddenBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.HiddenNodeDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NewNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeNameAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.TextElementDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.TextIDElementType;
import info.bioinfweb.treegraph.document.nodebranchdata.TextLabelAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.UniqueNameAdapter;
import info.bioinfweb.treegraph.document.tools.IDManager;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.AbstractFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.ErrorInfo;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.UndefinedIDException;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.string.ContainsFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.string.EndsWithFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.string.FirstIndexOfFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.string.LastIndexOfFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.string.ReplaceAllFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.string.ReplaceFirstFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.string.StartsWithFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.string.SubsequenceFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.string.ToLowerCaseFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.string.ToUpperCaseFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.topology.IndexInParentFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.topology.IsLeafFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.topology.IsRootFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.values.GetParentValueFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.values.GetValueFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.values.HasParentValueFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.values.HasValueFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.vararg.MaxFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.vararg.MeanFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.vararg.MinFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.vararg.ProductFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.vararg.SumFunction;
import info.bioinfweb.treegraph.document.undo.edit.calculatecolumn.vararg.VarArgFunction;
import info.bioinfweb.treegraph.document.undo.nodebranchdata.NodeBranchDataColumnBackup;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.nfunk.jep.JEP;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommandI;

public class CalculateColumnEdit
extends DocumentEdit {
    public static final String CURRENT_VALUE_VAR = "THIS";
    public static final String UNIQUE_NODE_NAMES_VAR = "UNIQUE";
    public static final String NODE_NAMES_VAR = "NAME";
    public static final String BRANCH_LENGTH_VAR = "LENGTH";
    public static final String UNKNOWN_FUNCTION_NAME_ERROR = "Syntax Error (implicit multiplication not enabled). This error can also occur if a misspelled function name was used.";
    private NodeBranchDataAdapter targetAdapter;
    private String targetColumnExpression;
    private TextIDElementType targetType;
    private String valueExpression;
    private boolean clearTargetColumns;
    private TextElementData defaultValue;
    private JEP parser;
    private Map<String, NodeBranchDataAdapter> adapterMap;
    private boolean isEvaluating = false;
    private boolean isEvaluatingDecimal = true;
    private Node position = null;
    private List<ErrorInfo> errors = new ArrayList<ErrorInfo>();
    private Map<String, NodeBranchDataColumnBackup> backups = new HashMap<String, NodeBranchDataColumnBackup>();

    public CalculateColumnEdit(Document document, NodeBranchDataAdapter targetAdapter, String targetColumnExpression, TextIDElementType targetType, String valueExpression, boolean clearTargetColumns, TextElementData defaultValue) {
        super(document, DocumentChangeType.TOPOLOGICAL_BY_RENAMING);
        if (targetAdapter == null) {
            if (targetColumnExpression == null) {
                throw new NullPointerException("targetColumnExpression must not be null while targetAdapter is also null.");
            }
            if (targetType == null) {
                throw new NullPointerException("targetType must not be null while targetAdapter is also null.");
            }
        }
        if (valueExpression == null) {
            throw new NullPointerException("valueExpression must not be null.");
        }
        this.targetAdapter = targetAdapter;
        this.targetColumnExpression = targetColumnExpression;
        this.targetType = targetType;
        this.valueExpression = valueExpression;
        this.clearTargetColumns = clearTargetColumns;
        this.defaultValue = defaultValue;
        this.parser = this.createParser();
        this.adapterMap = this.createAdapterMap();
        if (targetAdapter != null) {
            this.parser.addVariable(CURRENT_VALUE_VAR, (Object)targetAdapter);
            this.backups.put(this.getAdapterName(targetAdapter), new NodeBranchDataColumnBackup(targetAdapter, document.getTree().getPaintStart()));
        }
    }

    private String getAdapterName(NodeBranchDataAdapter adapter) {
        if (adapter instanceof NewNodeBranchDataAdapter) {
            adapter = ((NewNodeBranchDataAdapter)adapter).getPermanentAdapter();
        }
        return adapter.toString();
    }

    private void addFunction(JEP parser, AbstractFunction function) {
        parser.addFunction(function.getName(), (PostfixMathCommandI)function);
    }

    private void addVarArgFunction(JEP parser, VarArgFunction function) {
        this.addFunction(parser, function);
        this.addFunction(parser, function.createColumnsVersion());
        this.addFunction(parser, function.createLinesVersion());
    }

    private JEP createParser() {
        JEP result = new JEP();
        result.addStandardConstants();
        result.addStandardFunctions();
        result.addVariable(NODE_NAMES_VAR, (Object)NodeNameAdapter.getSharedInstance());
        result.addVariable(BRANCH_LENGTH_VAR, (Object)BranchLengthAdapter.getSharedInstance());
        this.addFunction(result, new GetValueFunction(this));
        this.addFunction(result, new HasValueFunction(this));
        this.addFunction(result, new GetParentValueFunction(this));
        this.addFunction(result, new HasParentValueFunction(this));
        this.addFunction(result, new IsRootFunction(this));
        this.addFunction(result, new IsLeafFunction(this));
        this.addFunction(result, new IndexInParentFunction(this));
        this.addVarArgFunction(result, new MinFunction(this));
        this.addVarArgFunction(result, new MaxFunction(this));
        this.addVarArgFunction(result, new SumFunction(this));
        this.addVarArgFunction(result, new ProductFunction(this));
        this.addVarArgFunction(result, new MeanFunction(this));
        this.addFunction(result, new ToUpperCaseFunction(this));
        this.addFunction(result, new ToLowerCaseFunction(this));
        this.addFunction(result, new SubsequenceFunction(this));
        this.addFunction(result, new ContainsFunction(this));
        this.addFunction(result, new StartsWithFunction(this));
        this.addFunction(result, new EndsWithFunction(this));
        this.addFunction(result, new FirstIndexOfFunction(this));
        this.addFunction(result, new LastIndexOfFunction(this));
        this.addFunction(result, new ReplaceAllFunction(this));
        this.addFunction(result, new ReplaceFirstFunction(this));
        return result;
    }

    private Map<String, NodeBranchDataAdapter> createAdapterMap() {
        HashMap<String, NodeBranchDataAdapter> result = new HashMap<String, NodeBranchDataAdapter>();
        String[] ids = IDManager.getLabelIDs(this.getDocument().getTree().getPaintStart(), TextLabel.class);
        int i = 0;
        while (i < ids.length) {
            result.put(ids[i], new TextLabelAdapter(ids[i], new DecimalFormat("0.0#####")));
            ++i;
        }
        ids = IDManager.getHiddenNodeDataIDs(this.getDocument().getTree().getPaintStart());
        i = 0;
        while (i < ids.length) {
            result.put(ids[i], new HiddenNodeDataAdapter(ids[i]));
            ++i;
        }
        ids = IDManager.getHiddenBranchDataIDs(this.getDocument().getTree().getPaintStart());
        i = 0;
        while (i < ids.length) {
            result.put(ids[i], new HiddenBranchDataAdapter(ids[i]));
            ++i;
        }
        return result;
    }

    public Node getPosition() {
        return this.position;
    }

    public boolean isEvaluating() {
        return this.isEvaluating;
    }

    public boolean isEvaluatingDecimal() {
        return this.isEvaluatingDecimal;
    }

    public NodeBranchDataAdapter getCurrentTargetAdapter() {
        return (NodeBranchDataAdapter)this.parser.getVarValue(CURRENT_VALUE_VAR);
    }

    private String evaluationStep(String expression) {
        String result = null;
        try {
            this.parser.evaluate(this.parser.parse(expression));
        }
        catch (ParseException e) {
            result = e.getErrorInfo();
        }
        return result;
    }

    public boolean evaluate() {
        this.isEvaluating = true;
        this.position = this.getDocument().getTree().getPaintStart();
        boolean result = true;
        try {
            String error;
            this.errors.clear();
            if (this.targetAdapter == null) {
                this.isEvaluatingDecimal = false;
                error = this.evaluationStep(this.targetColumnExpression);
                boolean bl = result = error == null;
                if (!result) {
                    this.errors.add(new ErrorInfo(error, false));
                }
            }
            if (result) {
                this.parser.addVariable(UNIQUE_NODE_NAMES_VAR, (Object)UniqueNameAdapter.getSharedInstance());
                if (this.targetAdapter != null) {
                    this.parser.addVariable(CURRENT_VALUE_VAR, (Object)this.targetAdapter);
                } else {
                    this.parser.addVariable(CURRENT_VALUE_VAR, (Object)NodeNameAdapter.getSharedInstance());
                }
                this.isEvaluatingDecimal = true;
                error = this.evaluationStep(this.valueExpression);
                boolean bl = result = error == null;
                if (!result) {
                    this.isEvaluatingDecimal = false;
                    error = this.evaluationStep(this.valueExpression);
                    boolean bl2 = result = error == null;
                    if (!result) {
                        this.errors.add(new ErrorInfo(error, true));
                    }
                }
            }
        }
        finally {
            this.isEvaluating = false;
            this.position = null;
        }
        return result;
    }

    public Object getValue(Node node, NodeBranchDataAdapter adapter) {
        if (this.isEvaluating) {
            if (this.isEvaluatingDecimal && !(adapter instanceof UniqueNameAdapter)) {
                return new Double(1.0);
            }
            return "a";
        }
        if (adapter.isDecimal(node)) {
            return new Double(adapter.getDecimal(node));
        }
        if (adapter.isString(node)) {
            return adapter.getText(node);
        }
        return null;
    }

    public boolean hasValue(Node node, NodeBranchDataAdapter adapter) {
        return this.isEvaluating || !adapter.isEmpty(node);
    }

    public NodeBranchDataAdapter getAdapterByID(String id) {
        return this.adapterMap.get(id);
    }

    public Object getIDValue(Node node, String id) throws ParseException {
        NodeBranchDataAdapter adapter = this.getAdapterByID(id);
        if (adapter != null) {
            return this.getValue(node, adapter);
        }
        this.throwUndefinedIDException(id);
        return null;
    }

    public void throwUndefinedIDException(String id) throws UndefinedIDException {
        throw new UndefinedIDException("A node/branch data column with the ID \"" + id + " \" does not exists.");
    }

    public boolean hasIDValue(Node node, String id) {
        return this.hasValue(node, this.getAdapterByID(id));
    }

    private NodeBranchDataAdapter calculateTargetAdapter() {
        if (this.targetAdapter == null) {
            NodeBranchDataAdapter result;
            this.parser.removeVariable(CURRENT_VALUE_VAR);
            this.parser.removeVariable(UNIQUE_NODE_NAMES_VAR);
            this.parser.parseExpression(this.targetColumnExpression);
            if (this.parser.hasError()) {
                this.errors.add(new ErrorInfo(this.position.getUniqueName(), this.parser.getErrorInfo(), false));
                return null;
            }
            Object value = this.parser.getValueAsObject();
            if (value instanceof NodeBranchDataAdapter) {
                result = (NodeBranchDataAdapter)value;
            } else if (value instanceof String) {
                String id = (String)value;
                result = this.getAdapterByID(id);
                if (result == null) {
                    result = this.targetType.createAdapterInstance(id, TextElementDataAdapter.DEFAULT_DECIMAL_FORMAT);
                    this.adapterMap.put(this.getAdapterName(result), result);
                }
            } else {
                String valueType = "null";
                if (value != null) {
                    valueType = value.getClass().getCanonicalName();
                }
                this.errors.add(new ErrorInfo(this.position.getUniqueName(), "The column ID expression did not result in a adapter or string (" + valueType + ").", false));
                return null;
            }
            this.parser.addVariable(CURRENT_VALUE_VAR, (Object)result);
            this.parser.addVariable(UNIQUE_NODE_NAMES_VAR, (Object)UniqueNameAdapter.getSharedInstance());
            return result;
        }
        return this.targetAdapter;
    }

    private void prepareColumn(NodeBranchDataAdapter adapter) {
        String key = this.getAdapterName(adapter);
        if (!this.backups.containsKey(key)) {
            this.backups.put(key, new NodeBranchDataColumnBackup(adapter, this.getDocument().getTree().getPaintStart()));
            if (this.clearTargetColumns) {
                this.clearColumn(adapter, this.getDocument().getTree().getPaintStart());
            }
        }
    }

    private void calculateSubtree(Node root) {
        this.position = root;
        NodeBranchDataAdapter adapter = this.calculateTargetAdapter();
        if (adapter != null) {
            this.prepareColumn(adapter);
            this.parser.parseExpression(this.valueExpression);
            if (this.parser.hasError()) {
                this.errors.add(new ErrorInfo(root.getUniqueName(), this.parser.getErrorInfo(), true));
            } else {
                Object result = this.parser.getValueAsObject();
                if (result instanceof Double) {
                    adapter.setDecimal(root, (Double)result);
                } else if (result instanceof String) {
                    adapter.setText(root, (String)result);
                } else if (result instanceof Boolean) {
                    double value = 0.0;
                    if (((Boolean)result).booleanValue()) {
                        value = 1.0;
                    }
                    adapter.setDecimal(root, value);
                } else {
                    adapter.delete(root);
                    this.errors.add(new ErrorInfo(root.getUniqueName(), "Invalid result type (Must be decimal or string.)", true));
                }
            }
        }
        int i = 0;
        while (i < root.getChildren().size()) {
            this.calculateSubtree(root.getChildren().get(i));
            ++i;
        }
    }

    private void clearColumn(NodeBranchDataAdapter adapter, Node root) {
        adapter.delete(root);
        for (Node child : root.getChildren()) {
            this.clearColumn(adapter, child);
        }
    }

    private void setDefaultValue() {
        if (this.defaultValue != null) {
            if (this.targetAdapter != null) {
                this.setDefaultValueInColumn(this.targetAdapter, this.getDocument().getTree().getPaintStart());
            } else {
                for (NodeBranchDataColumnBackup backup : this.backups.values()) {
                    this.setDefaultValueInColumn(backup.getAdapter(), this.getDocument().getTree().getPaintStart());
                }
            }
        }
    }

    private void setDefaultValueInColumn(NodeBranchDataAdapter adapter, Node root) {
        if (adapter.isEmpty(root) || adapter.isString(root) && adapter.getText(root).isEmpty()) {
            adapter.setTextElementData(root, this.defaultValue);
        }
        for (Node child : root.getChildren()) {
            this.setDefaultValueInColumn(adapter, child);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        this.errors.clear();
        if (this.targetAdapter != null && this.clearTargetColumns) {
            this.clearColumn(this.targetAdapter, this.getDocument().getTree().getPaintStart());
        }
        this.calculateSubtree(this.getDocument().getTree().getPaintStart());
        this.setDefaultValue();
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        for (NodeBranchDataColumnBackup backup : this.backups.values()) {
            backup.restore(this.getDocument().getTree().getPaintStart());
        }
        super.undo();
    }

    @Override
    public String getPresentationName() {
        String name = this.targetAdapter == null ? "node/branch data" : "\"" + this.getAdapterName(this.targetAdapter) + "\"";
        return "Calculate " + name;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<ErrorInfo> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }
}

