/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo.edit;

import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class BranchLengthEdit
extends DocumentEdit {
    private Branch branch;
    private double newLength;
    private double oldLength;

    public BranchLengthEdit(Document document, Branch branch, double newLength) {
        super(document, DocumentChangeType.POSITION);
        this.branch = branch;
        this.oldLength = branch.getLength();
        this.newLength = newLength;
    }

    @Override
    public void redo() throws CannotRedoException {
        this.branch.setLength(this.newLength);
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.branch.setLength(this.oldLength);
        super.undo();
    }

    @Override
    public String getPresentationName() {
        return "Edit branch length";
    }
}

