/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Legends;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import info.bioinfweb.treegraph.document.undo.WarningMessageEdit;
import javax.swing.undo.CannotUndoException;

public abstract class SaveLegendsEdit
extends DocumentEdit
implements WarningMessageEdit {
    private Legend[] legendsSave = null;
    private boolean legendsReanchored = false;
    private boolean legendsRemoved = false;

    public SaveLegendsEdit(Document document, DocumentChangeType changeType) {
        super(document, changeType);
    }

    protected Legend[] getLegendsSave() {
        return this.legendsSave;
    }

    protected void saveLegends() {
        if (this.legendsSave == null) {
            this.legendsSave = this.getDocument().getTree().getLegends().toArray(new Legend[0]);
            int i = 0;
            while (i < this.legendsSave.length) {
                this.legendsSave[i] = this.legendsSave[i].clone();
                ++i;
            }
        }
    }

    protected void restoreLegends() throws CannotUndoException {
        if (this.legendsSave == null) {
            throw new CannotUndoException();
        }
        Legends legends = this.getDocument().getTree().getLegends();
        legends.clear();
        int i = 0;
        while (i < this.legendsSave.length) {
            legends.insert(this.legendsSave[i]);
            ++i;
        }
    }

    public boolean getLegendsReanchored() {
        return this.legendsReanchored;
    }

    protected void setLegendsReanchored(boolean legendsReanchored) {
        this.legendsReanchored = legendsReanchored;
    }

    public boolean getLegendsRemoved() {
        return this.legendsRemoved;
    }

    protected void setLegendsRemoved(boolean legendsRemoved) {
        this.legendsRemoved = legendsRemoved;
    }

    @Override
    public String getWarningText() {
        String msg = "";
        if (this.getLegendsRemoved()) {
            msg = String.valueOf(msg) + "- One or more legend(s) that were only anchored inside the affected subtree were removed.\n";
        }
        if (this.getLegendsReanchored()) {
            msg = String.valueOf(msg) + "- One or more legend(s) that were anchored inside the affected subtree were reanchored.\n";
        }
        if ("".equals(msg)) {
            return null;
        }
        return "This process produced warnings:\n\n" + msg + "\nYou can use the undo-function to restore lost or changed data.";
    }

    @Override
    public boolean hasWarnings() {
        return this.getLegendsRemoved() || this.getLegendsReanchored();
    }

    protected void editSubtreeLegends(Node root) {
        Legends legends = this.getDocument().getTree().getLegends();
        int i = 0;
        while (i < legends.size()) {
            Legend l = legends.get(i);
            Node secondAnchor = l.getFormats().getAnchor(1);
            boolean firstIn = root.containedInSubtree(l.getFormats().getAnchor(0));
            boolean secondIn = root.containedInSubtree(secondAnchor);
            if (firstIn && secondIn || firstIn && secondAnchor == null) {
                legends.remove(l);
                --i;
                this.setLegendsRemoved(true);
            } else if (secondIn) {
                l.getFormats().setAnchor(1, null);
                this.setLegendsReanchored(true);
            } else if (firstIn) {
                l.getFormats().setAnchor(0, l.getFormats().getAnchor(1));
                l.getFormats().setAnchor(1, null);
                this.setLegendsReanchored(true);
            }
            ++i;
        }
    }
}

