/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo;

import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TreePath;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public abstract class ComplexDocumentEdit
extends DocumentEdit {
    private Node oldRoot = null;
    private Node newRoot = null;
    private boolean firstRedone = false;

    public ComplexDocumentEdit(Document document, DocumentChangeType changeType) {
        super(document, changeType);
        this.oldRoot = document.getTree().getPaintStart();
        this.newRoot = this.oldRoot.cloneWithSubtree(true);
    }

    public Node findEquivilant(Node old) {
        return new TreePath(old).findNode(this.newRoot);
    }

    public Branch findEquivalent(Branch old) {
        return new TreePath(old.getTargetNode()).findNode(this.newRoot).getAfferentBranch();
    }

    protected abstract void performRedo();

    @Override
    public void redo() throws CannotRedoException {
        this.getDocument().getTree().setPaintStart(this.newRoot);
        this.getDocument().getTree().updateElementSet();
        this.getDocument().getTree().assignUniqueNames();
        if (!this.firstRedone) {
            this.performRedo();
            this.newRoot = this.getDocument().getTree().getPaintStart();
            this.firstRedone = true;
        }
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.getDocument().getTree().setPaintStart(this.oldRoot);
        super.undo();
    }
}

