/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.undo;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.TextElementData;

public class CompareTextElementDataParameters {
    private boolean ignoreWhitespace = false;
    private boolean distinguishSpaceUnderscore = false;
    private boolean caseSensitive = false;
    private boolean parseNumericValues = true;

    public boolean isIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    public void setIgnoreWhitespace(boolean ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace;
    }

    public boolean isDistinguishSpaceUnderscore() {
        return this.distinguishSpaceUnderscore;
    }

    public void setDistinguishSpaceUnderscore(boolean distinguishSpaceUnderscore) {
        this.distinguishSpaceUnderscore = distinguishSpaceUnderscore;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isParseNumericValues() {
        return this.parseNumericValues;
    }

    public void setParseNumericValues(boolean parseNumbericValues) {
        this.parseNumericValues = parseNumbericValues;
    }

    public TextElementData createEditedValue(String text) {
        if (text == null || text.equals("")) {
            return new TextElementData();
        }
        TextElementData result = new TextElementData(text);
        if (this.isParseNumericValues()) {
            try {
                result.setDecimal(Math2.parseDouble(result.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (result.isString()) {
            if (this.isIgnoreWhitespace()) {
                result.setText(result.getText().trim());
            }
            if (!this.isCaseSensitive()) {
                result.setText(result.getText().toLowerCase());
            }
            if (!this.isDistinguishSpaceUnderscore()) {
                result.setText(result.getText().replaceAll(Character.toString('_'), " "));
            }
        }
        return result;
    }
}

