/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.topologicalcalculation;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.topologicalcalculation.LeafSet;
import info.bioinfweb.treegraph.document.topologicalcalculation.NodeInfo;
import info.bioinfweb.treegraph.document.undo.CompareTextElementDataParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TopologicalCalculator {
    protected Map<TextElementData, Integer> leafValueToIndexMap;
    protected Map<TextElementData, Integer> leafValueToIndexMapBackup;
    protected boolean processRooted;
    protected String keyLeafReference;
    protected CompareTextElementDataParameters parameters;

    public TopologicalCalculator(boolean processRooted, String keyLeafReference, CompareTextElementDataParameters parameters) {
        this.processRooted = processRooted;
        this.keyLeafReference = keyLeafReference;
        this.parameters = parameters;
        this.createNewIndexMap();
    }

    private void createNewIndexMap() {
        this.leafValueToIndexMap = new TreeMap<TextElementData, Integer>();
    }

    public boolean isProcessRooted() {
        return this.processRooted;
    }

    public void addSubtreeToLeafValueToIndexMap(Node root, NodeBranchDataAdapter adapter) {
        if (root.isLeaf()) {
            TextElementData data = this.parameters.createEditedValue(adapter.toTextElementData(root).toString());
            if (!this.leafValueToIndexMap.containsKey(data)) {
                this.leafValueToIndexMap.put(data, this.leafValueToIndexMap.size());
            }
        } else {
            for (Node child : root.getChildren()) {
                this.addSubtreeToLeafValueToIndexMap(child, adapter);
            }
        }
    }

    public void filterIndexMapBySubtree(Node root, NodeBranchDataAdapter adapter) {
        this.leafValueToIndexMapBackup = this.leafValueToIndexMap;
        this.createNewIndexMap();
        this.filterIndexMapBySubtreeRek(root, adapter);
        this.leafValueToIndexMapBackup = null;
    }

    private void filterIndexMapBySubtreeRek(Node root, NodeBranchDataAdapter adapter) {
        if (root.isLeaf()) {
            TextElementData data = this.parameters.createEditedValue(adapter.toTextElementData(root).toString());
            if (this.leafValueToIndexMapBackup.containsKey(data) && !this.leafValueToIndexMap.containsKey(data)) {
                this.leafValueToIndexMap.put(data, this.leafValueToIndexMap.size());
            }
        } else {
            for (Node child : root.getChildren()) {
                this.filterIndexMapBySubtreeRek(child, adapter);
            }
        }
    }

    public LeafSet getLeafSet(Node node) {
        if (node.getAttributeMap().get(this.keyLeafReference) == null) {
            int size = this.leafValueToIndexMap.size();
            if (this.processRooted) {
                ++size;
            }
            LeafSet field = new LeafSet(size);
            node.getAttributeMap().put(this.keyLeafReference, field);
        }
        return (LeafSet)node.getAttributeMap().get(this.keyLeafReference);
    }

    public int getLeafIndex(String value) {
        TextElementData key = this.parameters.createEditedValue(value);
        Integer result = this.leafValueToIndexMap.get(key);
        if (result == null) {
            return -1;
        }
        return result;
    }

    public int getLeafCount() {
        return this.leafValueToIndexMap.size();
    }

    public void addLeafSets(Node root, NodeBranchDataAdapter adapter) {
        root.getAttributeMap().remove(this.keyLeafReference);
        LeafSet field = this.getLeafSet(root);
        if (!root.isLeaf()) {
            int i = 0;
            while (i < root.getChildren().size()) {
                Node child = root.getChildren().get(i);
                this.addLeafSets(child, adapter);
                if (child.isLeaf()) {
                    int index = this.getLeafIndex(adapter.toTextElementData(child).toString());
                    if (index >= 0) {
                        field.setChild(index, true);
                    }
                } else {
                    field.addField(this.getLeafSet(child));
                }
                ++i;
            }
        } else {
            int index = this.getLeafIndex(adapter.toTextElementData(root).toString());
            if (index >= 0) {
                field.setChild(index, true);
            }
        }
    }

    public List<NodeInfo> findNodeWithAllLeaves(Tree tree, LeafSet leafSet) {
        ArrayList<NodeInfo> result = new ArrayList<NodeInfo>();
        this.findNodeWithAllLeavesRecursive(result, tree.getPaintStart(), leafSet);
        return result;
    }

    private void findNodeWithAllLeavesRecursive(List<NodeInfo> result, Node root, LeafSet searchedLeafSet) {
        if (!this.isLeafSetEmpty(searchedLeafSet)) {
            boolean downwards;
            LeafSet comparedLeafSet = this.getLeafSet(root);
            int additionalCount = searchedLeafSet.compareTo(comparedLeafSet, false);
            boolean bl = downwards = additionalCount != -1;
            if (!downwards) {
                additionalCount = searchedLeafSet.compareTo(comparedLeafSet, true);
            }
            NodeInfo info = new NodeInfo(root, additionalCount, downwards);
            if (additionalCount != -1) {
                if (result.isEmpty()) {
                    result.add(info);
                } else {
                    int previousAdditionalCount = result.get(0).getAdditionalCount();
                    if (additionalCount < previousAdditionalCount) {
                        result.clear();
                        result.add(info);
                    } else if (additionalCount == previousAdditionalCount) {
                        result.add(info);
                    }
                }
            }
            for (Node child : root.getChildren()) {
                this.findNodeWithAllLeavesRecursive(result, child, searchedLeafSet);
            }
        }
    }

    public Node findHighestConflict(Node searchRoot, LeafSet conflictNodeLeafSet, NodeBranchDataAdapter supportAdapter, boolean parseText) {
        Node highestConflictingNode = null;
        int i = 0;
        while (i < searchRoot.getChildren().size()) {
            highestConflictingNode = this.findHighestConflictRecursive(searchRoot.getChildren().get(i), conflictNodeLeafSet, highestConflictingNode, supportAdapter, parseText);
            ++i;
        }
        return highestConflictingNode;
    }

    private Node findHighestConflictRecursive(Node searchRoot, LeafSet conflictNodeLeafSet, Node highestConflictingNode, NodeBranchDataAdapter supportAdapter, boolean parseText) {
        double currentSupport;
        LeafSet currentSearchRootLeafSet = this.getLeafSet(searchRoot);
        if ((currentSearchRootLeafSet.containsAnyAndOther(conflictNodeLeafSet, false) || currentSearchRootLeafSet.containsAnyAndOther(conflictNodeLeafSet, true)) && !Double.isNaN(currentSupport = supportAdapter.getNumericValue(searchRoot, parseText))) {
            if (highestConflictingNode == null) {
                highestConflictingNode = searchRoot;
            } else {
                double previousSupport = supportAdapter.getNumericValue(highestConflictingNode, parseText);
                if (previousSupport < currentSupport) {
                    highestConflictingNode = searchRoot;
                }
            }
        }
        int i = 0;
        while (i < searchRoot.getChildren().size()) {
            highestConflictingNode = this.findHighestConflictRecursive(searchRoot.getChildren().get(i), conflictNodeLeafSet, highestConflictingNode, supportAdapter, parseText);
            ++i;
        }
        return highestConflictingNode;
    }

    public Node findHighestConflict(Tree referenceTree, Tree searchedTree, Node searchRoot, LeafSet conflictingReferenceLeafSet, LeafSet completeSearchedLeafSet, NodeBranchDataAdapter searchedSupportAdapter) {
        LeafSet referenceRootLeafSet = this.getLeafSet(referenceTree.getPaintStart());
        completeSearchedLeafSet = completeSearchedLeafSet.and(referenceRootLeafSet);
        conflictingReferenceLeafSet = conflictingReferenceLeafSet.and(this.getLeafSet(searchedTree.getPaintStart()));
        return this.findHighestConflictRecursive(searchRoot, referenceRootLeafSet, null, conflictingReferenceLeafSet, completeSearchedLeafSet, searchedSupportAdapter);
    }

    private Node findHighestConflictRecursive(Node currentSearchRoot, LeafSet referenceRootLeafSet, Node highestConflictingNode, LeafSet conflictingReferenceLeafSet, LeafSet completeSearchedLeafSet, NodeBranchDataAdapter searchedSupportAdapter) {
        LeafSet currentSearchRootLeafSet = this.getLeafSet(currentSearchRoot).and(referenceRootLeafSet);
        if (currentSearchRootLeafSet.containsAnyAndOther(conflictingReferenceLeafSet, false) && currentSearchRootLeafSet.inSubtreeOf(completeSearchedLeafSet, false) || currentSearchRootLeafSet.containsAnyAndOther(conflictingReferenceLeafSet, true) && currentSearchRootLeafSet.inSubtreeOf(completeSearchedLeafSet, true)) {
            double currentSupport = Double.NaN;
            if (searchedSupportAdapter.isDecimal(currentSearchRoot)) {
                currentSupport = searchedSupportAdapter.getDecimal(currentSearchRoot);
            } else if (searchedSupportAdapter.isString(currentSearchRoot)) {
                try {
                    currentSupport = Math2.parseDouble(searchedSupportAdapter.getText(currentSearchRoot));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!Double.isNaN(currentSupport)) {
                if (highestConflictingNode == null) {
                    highestConflictingNode = currentSearchRoot;
                } else {
                    double previousSupport = searchedSupportAdapter.isDecimal(highestConflictingNode) ? searchedSupportAdapter.getDecimal(highestConflictingNode) : Math2.parseDouble(searchedSupportAdapter.getText(highestConflictingNode));
                    if (previousSupport < currentSupport) {
                        highestConflictingNode = currentSearchRoot;
                    }
                }
            }
        }
        int i = 0;
        while (i < currentSearchRoot.getChildren().size()) {
            highestConflictingNode = this.findHighestConflictRecursive(currentSearchRoot.getChildren().get(i), referenceRootLeafSet, highestConflictingNode, conflictingReferenceLeafSet, completeSearchedLeafSet, searchedSupportAdapter);
            ++i;
        }
        return highestConflictingNode;
    }

    private boolean isLeafSetEmpty(LeafSet leafSet) {
        int i = 0;
        while (i < leafSet.size()) {
            if (leafSet.isChild(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

