/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.topologicalcalculation;

import info.bioinfweb.commons.Math2;

public class LeafSet {
    private int[] field;
    private int size;

    public LeafSet(int size) {
        this.field = new int[Math2.divAbove(size, 32)];
        this.size = size;
        int i = 0;
        while (i < this.field.length) {
            this.field[i] = 0;
            ++i;
        }
    }

    public int hashCode() {
        int result = 0;
        int i = 0;
        while (i < this.field.length) {
            result += this.field[i];
            ++i;
        }
        return result;
    }

    public boolean isChild(int pos) {
        return (this.field[pos / 32] & Math2.intPow(2, pos % 32)) != 0;
    }

    public void setChild(int pos, boolean value) {
        this.field[pos / 32] = value ? this.field[pos / 32] | Math2.intPow(2, pos % 32) : this.field[pos / 32] & ~Math2.intPow(2, pos % 32);
    }

    public int size() {
        return this.size;
    }

    public int childCount() {
        int result = 0;
        int pos = 0;
        while (pos < this.size()) {
            if (this.isChild(pos)) {
                ++result;
            }
            ++pos;
        }
        return result;
    }

    public void addField(LeafSet other) {
        int i = 0;
        while (i < other.size()) {
            if (other.isChild(i)) {
                this.setChild(i, true);
            }
            ++i;
        }
    }

    public LeafSet and(LeafSet other) {
        if (other.size() != this.size()) {
            throw new IllegalArgumentException();
        }
        LeafSet result = new LeafSet(this.size());
        int i = 0;
        while (i < this.field.length) {
            result.field[i] = this.field[i] & other.field[i];
            ++i;
        }
        return result;
    }

    public int compareTo(LeafSet other, boolean complement) {
        int additionalCount = 0;
        int i = 0;
        while (i < this.size()) {
            boolean isChildHere = this.isChild(i);
            if (complement) {
                boolean bl = isChildHere = !isChildHere;
            }
            if (isChildHere) {
                if (!other.isChild(i)) {
                    return -1;
                }
            } else if (other.isChild(i)) {
                ++additionalCount;
            }
            ++i;
        }
        return additionalCount;
    }

    public boolean inSubtreeOf(LeafSet parent, boolean complement) {
        boolean oneLess = false;
        int i = 0;
        while (i < this.size()) {
            boolean isChildHere = this.isChild(i);
            if (complement) {
                boolean bl = isChildHere = !isChildHere;
            }
            if (isChildHere && !parent.isChild(i)) {
                return false;
            }
            oneLess = oneLess || !isChildHere && parent.isChild(i);
            ++i;
        }
        return oneLess;
    }

    public LeafSet complement() {
        LeafSet result = new LeafSet(this.size());
        int i = 0;
        while (i < this.field.length) {
            result.field[i] = ~this.field[i];
            ++i;
        }
        return result;
    }

    public boolean containsAnyAndOther(LeafSet other, boolean complement) {
        boolean containsOther = false;
        boolean containsAny = false;
        int i = 0;
        while (i < this.size()) {
            boolean isChildHere = this.isChild(i);
            if (complement) {
                isChildHere = !isChildHere;
            }
            containsAny = containsAny || isChildHere && other.isChild(i);
            boolean bl = containsOther = containsOther || isChildHere && !other.isChild(i);
            if (containsAny && containsOther) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsAll(LeafSet subset) {
        if (subset.size() == this.size()) {
            int i = 0;
            while (i < this.field.length) {
                if ((this.field[i] & subset.field[i]) != subset.field[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        throw new IllegalArgumentException("The other set has a different size than this set. Comparing sets of different sizes is not allowed.");
    }

    public boolean equals(Object other) {
        LeafSet otherField;
        if (other instanceof LeafSet && (otherField = (LeafSet)other).size() == this.size() && this.size() > 0) {
            int i = 0;
            while (i < this.field.length) {
                if (this.field[i] != otherField.field[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.size());
        int i = 0;
        while (i < this.size()) {
            if (this.isChild(i)) {
                result.append("1");
            } else {
                result.append("0");
            }
            ++i;
        }
        return result.toString();
    }
}

