/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.tools;

import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Labels;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.NodeType;
import info.bioinfweb.treegraph.document.PaintableElement;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.TreePath;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.TextElementDataAdapter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TreeSerializer {
    private static void addLabelBlock(Collection<PaintableElement> list, Labels labels, boolean above) {
        int lineNo = 0;
        while (lineNo < labels.lineCount(above)) {
            int lineIndex = 0;
            while (lineIndex < labels.labelCount(above, lineNo)) {
                list.add(labels.get(above, lineNo, lineIndex));
                ++lineIndex;
            }
            ++lineNo;
        }
    }

    public static <T extends PaintableElement> void addElementsOnNode(Collection<T> list, Node node, Class<? extends T> c) {
        if (c.isInstance(node)) {
            list.add(node);
        }
        if (c.isInstance(node.getAfferentBranch())) {
            list.add(node.getAfferentBranch());
        }
        Label[] labels = node.getAfferentBranch().getLabels().toLabelArray();
        int i = 0;
        while (i < labels.length) {
            if (c.isInstance(labels[i])) {
                list.add(labels[i]);
            }
            ++i;
        }
    }

    public static <T extends PaintableElement> T[] getElementsOnNode(Node node, Class<T> c, T[] array) {
        ArrayList list = new ArrayList();
        TreeSerializer.addElementsOnNode(list, node, c);
        return (PaintableElement[])list.toArray(array);
    }

    public static <T extends PaintableElement> T[] getElementsOnNode(Node node, Class<T> c) {
        return TreeSerializer.getElementsOnNode((Node)node, c, (PaintableElement[])((PaintableElement[])Array.newInstance(c, 0)));
    }

    public static <T extends PaintableElement> void addElementsInSubtree(Collection<T> list, Node root, NodeType nodeType, Class<? extends T> elementClass) {
        if (root.isLeaf() && !nodeType.equals((Object)NodeType.INTERNAL_NODES) || !root.isLeaf() && !nodeType.equals((Object)NodeType.LEAVES)) {
            TreeSerializer.addElementsOnNode(list, root, elementClass);
        }
        int i = 0;
        while (i < root.getChildren().size()) {
            TreeSerializer.addElementsInSubtree(list, root.getChildren().get(i), nodeType, elementClass);
            ++i;
        }
    }

    public static <T extends PaintableElement> T[] getElementsInSubtree(Node root, NodeType nodeType, Class<? extends T> elementClass, T[] array) {
        return (PaintableElement[])TreeSerializer.getElementsInSubtreeAsList(root, nodeType, elementClass).toArray(array);
    }

    public static <T extends PaintableElement> List<T> getElementsInSubtreeAsList(Node root, NodeType nodeType, Class<? extends T> elementClass) {
        ArrayList list = new ArrayList();
        TreeSerializer.addElementsInSubtree(list, root, nodeType, elementClass);
        return list;
    }

    public static <T extends PaintableElement> T[] getElementsInSubtree(Node root, NodeType nodeType, Class<T> elementClass) {
        return TreeSerializer.getElementsInSubtree((Node)root, (NodeType)nodeType, elementClass, (PaintableElement[])((PaintableElement[])Array.newInstance(elementClass, 0)));
    }

    private static void addLeafNodesBetween(Collection<Node> list, Node root, int level, TreePath upperPath, TreePath lowerPath) {
        if (root.isLeaf()) {
            list.add(root);
        } else {
            int start = 0;
            int end = root.getChildren().size() - 1;
            if (upperPath != null) {
                start = upperPath.getPosition(level);
            }
            if (lowerPath != null) {
                end = lowerPath.getPosition(level);
            }
            int i = start;
            while (i <= end) {
                TreePath currentUpperPath = null;
                if (i == start) {
                    currentUpperPath = upperPath;
                }
                TreePath currentLowerPath = null;
                if (i == end) {
                    currentLowerPath = lowerPath;
                }
                TreeSerializer.addLeafNodesBetween(list, root.getChildren().get(i), level + 1, currentUpperPath, currentLowerPath);
                ++i;
            }
        }
    }

    public static Node[] getLeafNodesBetween(Node upperLeaf, Node lowerLeaf) {
        Node ancestor = Tree.mostRecentCommonAncestor(upperLeaf, lowerLeaf);
        if (ancestor == null) {
            throw new IllegalArgumentException("The specified nodes are not part of the same tree.");
        }
        ArrayList<Node> list = new ArrayList<Node>();
        TreePath upperPath = new TreePath(upperLeaf, ancestor);
        TreePath lowerPath = new TreePath(lowerLeaf, ancestor);
        TreeSerializer.addLeafNodesBetween(list, ancestor, 0, upperPath, lowerPath);
        return list.toArray(new Node[list.size()]);
    }

    private static void getLabelsWithIDInBlock(Collection<Label> list, Labels labels, boolean above, String id) {
        int lineNo = 0;
        while (lineNo < labels.lineCount(above)) {
            int lineIndex = 0;
            while (lineIndex < labels.labelCount(above, lineNo)) {
                Label label = labels.get(above, lineNo, lineIndex);
                if (label.getID().equals(id)) {
                    list.add(label);
                }
                ++lineIndex;
            }
            ++lineNo;
        }
    }

    private static void addLabelsWithID(Collection<Label> list, Node root, String id) {
        if (root.hasAfferentBranch()) {
            Labels labels = root.getAfferentBranch().getLabels();
            TreeSerializer.getLabelsWithIDInBlock(list, labels, true, id);
            TreeSerializer.getLabelsWithIDInBlock(list, labels, false, id);
        }
        int i = 0;
        while (i < root.getChildren().size()) {
            TreeSerializer.addLabelsWithID(list, root.getChildren().get(i), id);
            ++i;
        }
    }

    public static Label[] getLabelsWithID(Node root, String id) {
        ArrayList<Label> list = new ArrayList<Label>();
        TreeSerializer.addLabelsWithID(list, root, id);
        return list.toArray(new Label[list.size()]);
    }

    public static Legend[] getLegendsInSubtree(Tree tree, Node root) {
        if (!tree.contains(root)) {
            throw new IllegalArgumentException("The specified root is not contained in the specified tree.");
        }
        ArrayList<Legend> result = new ArrayList<Legend>();
        int i = 0;
        while (i < tree.getLegends().size()) {
            Legend l = tree.getLegends().get(i);
            if (root.containedInSubtree(l)) {
                result.add(l);
            }
            ++i;
        }
        return result.toArray(new Legend[result.size()]);
    }

    public static <C extends Collection<TextElementData>> C addTextElementDataFromSubtree(C collection, Node root, NodeType nodeType, TextElementDataAdapter adapter, Collection<TextElementData> ignoredElements) {
        if (root.isLeaf() && !nodeType.equals((Object)NodeType.INTERNAL_NODES) || !root.isLeaf() && !nodeType.equals((Object)NodeType.LEAVES)) {
            TextElementData data = adapter.getData(root);
            if (ignoredElements == null || !ignoredElements.contains(data)) {
                collection.add((TextElementData)data);
            }
        }
        for (Node child : root.getChildren()) {
            TreeSerializer.addTextElementDataFromSubtree(collection, child, nodeType, adapter, ignoredElements);
        }
        return collection;
    }

    public static <C extends Collection<TextElementData>> C addTextElementDataCopiesFromSubtree(C collection, Node root, NodeType nodeType, NodeBranchDataAdapter adapter, Collection<TextElementData> ignoredElements) {
        if (root.isLeaf() && !nodeType.equals((Object)NodeType.INTERNAL_NODES) || !root.isLeaf() && !nodeType.equals((Object)NodeType.LEAVES)) {
            TextElementData data = adapter.toTextElementData(root);
            if (ignoredElements == null || !ignoredElements.contains(data)) {
                collection.add((TextElementData)data);
            }
        }
        for (Node child : root.getChildren()) {
            TreeSerializer.addTextElementDataCopiesFromSubtree(collection, child, nodeType, adapter, ignoredElements);
        }
        return collection;
    }
}

