/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.tools;

import info.bioinfweb.commons.RandomValues;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.HiddenDataElement;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Labels;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.PieChartLabel;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.nodebranchdata.IDElementAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class IDManager {
    public static final String RAND_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890";
    public static final int RAND_LENGTH = 12;
    private static final Comparator<String> STRING_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    };

    private static void searchLabelIDsInLabelBlock(Labels labels, boolean above, Class<? extends Label> labelClass, List<String> list) {
        int lineNo = 0;
        while (lineNo < labels.lineCount(above)) {
            int lineIndex = 0;
            while (lineIndex < labels.labelCount(above, lineNo)) {
                Label l = labels.get(above, lineNo, lineIndex);
                String id = l.getID();
                if (!id.equals("") && id != null && !list.contains(id) && labelClass.isInstance(l)) {
                    list.add(id);
                }
                ++lineIndex;
            }
            ++lineNo;
        }
    }

    private static void searchHiddenDataIDs(HiddenDataElement element, List<String> list) {
        Iterator<String> iterator = element.getHiddenDataMap().idIterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            if (id.equals("") || list.contains(id)) continue;
            list.add(id);
        }
    }

    private static void searchIDsOnNode(Node node, List<String> list, Class<? extends Label> labelClass, boolean includeHiddenNodeData, boolean includeHiddenBranchData) {
        if (node.hasAfferentBranch()) {
            Labels labels = node.getAfferentBranch().getLabels();
            if (labelClass != null) {
                IDManager.searchLabelIDsInLabelBlock(labels, true, labelClass, list);
                IDManager.searchLabelIDsInLabelBlock(labels, false, labelClass, list);
            }
            if (includeHiddenNodeData) {
                IDManager.searchHiddenDataIDs(node, list);
            }
            if (includeHiddenBranchData) {
                IDManager.searchHiddenDataIDs(node.getAfferentBranch(), list);
            }
        }
    }

    private static void searchIDsInSubtree(Node root, List<String> list, Class<? extends Label> labelClass, boolean includeHiddenNodeData, boolean includeHiddenBranchData) {
        if (root != null) {
            IDManager.searchIDsOnNode(root, list, labelClass, includeHiddenNodeData, includeHiddenBranchData);
            int i = 0;
            while (i < root.getChildren().size()) {
                IDManager.searchIDsInSubtree(root.getChildren().get(i), list, labelClass, includeHiddenNodeData, includeHiddenBranchData);
                ++i;
            }
        }
    }

    public static String[] getIDs(Node root) {
        List<String> list = IDManager.getIDListFromSubtree(root);
        return list.toArray(new String[list.size()]);
    }

    public static boolean containsIDElements(Node root) {
        if (root == null) {
            return false;
        }
        if (!(root.getAfferentBranch().getLabels().isEmpty() && root.getHiddenDataMap().isEmpty() && root.getAfferentBranch().getHiddenDataMap().isEmpty())) {
            return true;
        }
        int i = 0;
        while (i < root.getChildren().size()) {
            if (IDManager.containsIDElements(root.getChildren().get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] getLabelIDs(Node root, Class<? extends Label> labelClass) {
        List<String> list = IDManager.getLabelIDListFromSubtree(root, labelClass);
        return list.toArray(new String[list.size()]);
    }

    public static String[] getHiddenBranchDataIDs(Node root) {
        List<String> list = IDManager.getHiddenBranchDataIDListFromSubtree(root);
        return list.toArray(new String[list.size()]);
    }

    public static String[] getHiddenNodeDataIDs(Node root) {
        List<String> list = IDManager.getHiddenNodeDataIDListFromSubtree(root);
        return list.toArray(new String[list.size()]);
    }

    public static List<String> getListFromSubtree(Node root, Class<? extends Label> labelClass, boolean includeHiddenNodeData, boolean includeHiddenBranchData) {
        Vector<String> list = new Vector<String>();
        IDManager.searchIDsInSubtree(root, list, labelClass, includeHiddenNodeData, includeHiddenBranchData);
        Collections.sort(list, STRING_COMPARATOR);
        return list;
    }

    private static List<String> getListFromNode(Node node, Class<? extends Label> labelClass, boolean includeNodeHiddenData, boolean includeBranchHiddenData) {
        Vector<String> list = new Vector<String>();
        IDManager.searchIDsOnNode(node, list, labelClass, includeNodeHiddenData, includeBranchHiddenData);
        Collections.sort(list, STRING_COMPARATOR);
        return list;
    }

    public static List<String> getIDListFromSubtree(Node root) {
        return IDManager.getListFromSubtree(root, Label.class, true, true);
    }

    public static List<String> getIDListFromNode(Node root) {
        return IDManager.getListFromNode(root, Label.class, true, true);
    }

    public static List<String> getLabelIDListFromSubtree(Node root, Class<? extends Label> labelClass) {
        return IDManager.getListFromSubtree(root, labelClass, false, false);
    }

    public static List<String> getHiddenBranchDataIDListFromSubtree(Node root) {
        return IDManager.getListFromSubtree(root, null, false, true);
    }

    public static List<String> getHiddenNodeDataIDListFromSubtree(Node root) {
        return IDManager.getListFromSubtree(root, null, true, false);
    }

    private static void renameLabelIDInLabelBlock(String oldName, String newName, Labels labels, boolean above) {
        int lineNo = 0;
        while (lineNo < labels.lineCount(above)) {
            int lineIndex = 0;
            while (lineIndex < labels.labelCount(above, lineNo)) {
                Label l = labels.get(above, lineNo, lineIndex);
                if (oldName.equals(l.getID())) {
                    l.setID(newName);
                }
                ++lineIndex;
            }
            ++lineNo;
        }
    }

    private static void renameHiddenDataID(HiddenDataElement element, String oldName, String newName) {
        TextElementData value = element.getHiddenDataMap().get(oldName);
        if (value != null) {
            element.getHiddenDataMap().remove(oldName);
            element.getHiddenDataMap().put(newName, value);
        }
    }

    public static void renameID(String oldName, String newName, Node node) {
        IDManager.renameLabelIDInLabelBlock(oldName, newName, node.getAfferentBranch().getLabels(), true);
        IDManager.renameLabelIDInLabelBlock(oldName, newName, node.getAfferentBranch().getLabels(), false);
        IDManager.renameHiddenDataID(node.getAfferentBranch(), oldName, newName);
        IDManager.renameHiddenDataID(node, oldName, newName);
    }

    private static void renameIDSubtree(String oldName, String newName, Node root) {
        IDManager.renameID(oldName, newName, root);
        int i = 0;
        while (i < root.getChildren().size()) {
            IDManager.renameIDSubtree(oldName, newName, root.getChildren().get(i));
            ++i;
        }
    }

    private static void updatePieChartLabels(String oldName, String newName, Node root) {
        PieChartLabel[] labels = root.getAfferentBranch().getLabels().toPieChartLabelArray();
        int i = 0;
        while (i < labels.length) {
            int j = 0;
            while (j < labels[i].getSectionDataList().size()) {
                if (oldName.equals(labels[i].getSectionDataList().get(j).getValueColumnID())) {
                    labels[i].getSectionDataList().get(j).setValueColumnID(newName);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < root.getChildren().size()) {
            IDManager.updatePieChartLabels(oldName, newName, root.getChildren().get(i));
            ++i;
        }
    }

    private static void updateDefaultAdapter(String oldName, String newName, NodeBranchDataAdapter adapter) {
        IDElementAdapter idAdapter;
        if (adapter instanceof IDElementAdapter && (idAdapter = (IDElementAdapter)adapter).getID().equals(oldName)) {
            idAdapter.setID(newName);
        }
    }

    public static void renameID(String oldName, String newName, Document document) {
        if (!document.getTree().isEmpty()) {
            IDManager.renameIDSubtree(oldName, newName, document.getTree().getPaintStart());
            IDManager.updatePieChartLabels(oldName, newName, document.getTree().getPaintStart());
        }
        IDManager.updateDefaultAdapter(oldName, newName, document.getDefaultLeafAdapter());
        IDManager.updateDefaultAdapter(oldName, newName, document.getDefaultSupportAdapter());
    }

    public static String newID(List<String> ids) {
        String result;
        while (ids.contains(result = RandomValues.randChars(RAND_CHARS, 12))) {
        }
        return result;
    }

    public static String newID(String id, List<String> ids) {
        String result = id;
        int index = 1;
        while (ids.contains(id)) {
            result = String.valueOf(id) + index;
            ++index;
        }
        return result;
    }

    public static TextElementData getDataByID(Node node, String id) {
        TextElementData result = null;
        Label l = node.getAfferentBranch().getLabels().get(id);
        if (l != null && l instanceof TextLabel) {
            result = ((TextLabel)l).getData();
        } else {
            result = node.getHiddenDataMap().get(id);
            if (result == null) {
                result = node.getAfferentBranch().getHiddenDataMap().get(id);
            }
        }
        return result;
    }

    public static Object getElementByID(Node node, String id) {
        Cloneable result = node.getAfferentBranch().getLabels().get(id);
        if (result == null && (result = node.getHiddenDataMap().get(id)) == null) {
            result = node.getAfferentBranch().getHiddenDataMap().get(id);
        }
        return result;
    }

    public static Object removeElementWithID(Node node, String id) {
        Labels labels = node.getAfferentBranch().getLabels();
        Cloneable result = labels.get(id);
        if (result != null) {
            labels.remove((Label)result);
        } else {
            result = node.getHiddenDataMap().remove(id);
            if (result == null) {
                result = node.getAfferentBranch().getHiddenDataMap().remove(id);
            }
        }
        return result;
    }

    public static Label getFirstLabel(Node root, Class<? extends Label> elementClass, String id) {
        Label l = root.getAfferentBranch().getLabels().get(id);
        if (elementClass.isInstance(l)) {
            return l;
        }
        int i = 0;
        while (i < root.getChildren().size()) {
            l = IDManager.getFirstLabel(root.getChildren().get(i), elementClass, id);
            if (elementClass.isInstance(l)) {
                return l;
            }
            ++i;
        }
        return null;
    }

    public static boolean idExistsInSubtree(Node root, String id) {
        return IDManager.getIDListFromSubtree(root).contains(id);
    }

    public static boolean idExistsOnNode(Node node, String id) {
        return IDManager.getIDListFromNode(node).contains(id);
    }

    public static boolean idConflict(String id, Branch[] selection) {
        int i = 0;
        while (i < selection.length) {
            if (IDManager.idExistsOnNode(selection[i].getTargetNode(), id)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

