/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.nodebranchdata.factory;

import info.bioinfweb.treegraph.document.nodebranchdata.BranchLengthAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.GeneralIDAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.HiddenBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.HiddenNodeDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeNameAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.PieChartLabelAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.TextLabelAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.UniqueNameAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.VoidNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.factory.SingleNodeBranchDataAdapterFactory;
import java.util.Map;
import java.util.TreeMap;

public class NodeBranchDataAdapterFactory {
    private static NodeBranchDataAdapterFactory firstInstance = null;
    private Map<String, SingleNodeBranchDataAdapterFactory<NodeBranchDataAdapter>> factories = new TreeMap<String, SingleNodeBranchDataAdapterFactory<NodeBranchDataAdapter>>();

    private NodeBranchDataAdapterFactory() {
        this.fillFactoryMap();
    }

    private void fillFactoryMap() {
        this.factories.put(BranchLengthAdapter.getSharedInstance().getName(), new SingleNodeBranchDataAdapterFactory<NodeBranchDataAdapter>(){

            @Override
            public NodeBranchDataAdapter newInstance(String id) {
                return BranchLengthAdapter.getSharedInstance();
            }
        });
        this.factories.put(new GeneralIDAdapter("").getName(), new SingleNodeBranchDataAdapterFactory<NodeBranchDataAdapter>(){

            @Override
            public NodeBranchDataAdapter newInstance(String id) {
                return new GeneralIDAdapter(id);
            }
        });
        this.factories.put(new HiddenBranchDataAdapter("").getName(), new SingleNodeBranchDataAdapterFactory<NodeBranchDataAdapter>(){

            @Override
            public NodeBranchDataAdapter newInstance(String id) {
                return new HiddenBranchDataAdapter(id);
            }
        });
        this.factories.put(new HiddenNodeDataAdapter("").getName(), new SingleNodeBranchDataAdapterFactory<NodeBranchDataAdapter>(){

            @Override
            public NodeBranchDataAdapter newInstance(String id) {
                return new HiddenNodeDataAdapter(id);
            }
        });
        this.factories.put(NodeNameAdapter.getSharedInstance().getName(), new SingleNodeBranchDataAdapterFactory<NodeBranchDataAdapter>(){

            @Override
            public NodeBranchDataAdapter newInstance(String id) {
                return NodeNameAdapter.getSharedInstance();
            }
        });
        this.factories.put(new PieChartLabelAdapter("").getName(), new SingleNodeBranchDataAdapterFactory<NodeBranchDataAdapter>(){

            @Override
            public NodeBranchDataAdapter newInstance(String id) {
                return new PieChartLabelAdapter(id);
            }
        });
        this.factories.put(new TextLabelAdapter("", null).getName(), new SingleNodeBranchDataAdapterFactory<NodeBranchDataAdapter>(){

            @Override
            public NodeBranchDataAdapter newInstance(String id) {
                return new TextLabelAdapter(id);
            }
        });
        this.factories.put(UniqueNameAdapter.getSharedInstance().getName(), new SingleNodeBranchDataAdapterFactory<NodeBranchDataAdapter>(){

            @Override
            public NodeBranchDataAdapter newInstance(String id) {
                return UniqueNameAdapter.getSharedInstance();
            }
        });
        this.factories.put(new VoidNodeBranchDataAdapter("").getName(), new SingleNodeBranchDataAdapterFactory<NodeBranchDataAdapter>(){

            @Override
            public NodeBranchDataAdapter newInstance(String id) {
                return new VoidNodeBranchDataAdapter("No support values available");
            }
        });
    }

    public static NodeBranchDataAdapterFactory getInstance() {
        if (firstInstance == null) {
            firstInstance = new NodeBranchDataAdapterFactory();
        }
        return firstInstance;
    }

    public NodeBranchDataAdapter newAdapterInstance(String name, String id) {
        return this.factories.get(name).newInstance(id);
    }
}

