/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.nodebranchdata;

import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Labels;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.format.TextFormats;
import info.bioinfweb.treegraph.document.nodebranchdata.AbstractIDElementAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import java.text.DecimalFormat;

public class TextLabelAdapter
extends AbstractIDElementAdapter
implements NodeBranchDataAdapter {
    public TextLabelAdapter(String labelID, DecimalFormat defaultDecimalFormat) {
        super(labelID, defaultDecimalFormat);
    }

    public TextLabelAdapter(String id) {
        super(id);
    }

    @Override
    public String getName() {
        return "info.bioinfweb.treegraph.textLabelAdapter";
    }

    @Override
    public TextElementData getData(Node node) {
        TextLabel l = this.getDataElement(node);
        if (l != null && l instanceof TextLabel) {
            return l.getData();
        }
        return null;
    }

    @Override
    public boolean assignData(Node node, TextElementData data) {
        boolean result;
        TextLabel l = this.getDataElement(node);
        boolean bl = result = l != null && l instanceof TextLabel;
        if (result) {
            l.getData().assign(data);
        }
        return result;
    }

    @Override
    public DecimalFormat getDecimalFormat(Node node) {
        Label l = node.getAfferentBranch().getLabels().get(this.getID());
        if (l != null && l instanceof TextLabel) {
            return ((TextLabel)l).getFormats().getDecimalFormat();
        }
        return super.getDecimalFormat(node);
    }

    @Override
    protected void createData(Node node) {
        Labels labels;
        Label label;
        if (node.hasAfferentBranch() && ((label = (labels = node.getAfferentBranch().getLabels()).get(this.getID())) == null || !(label instanceof TextLabel))) {
            label = new TextLabel(labels);
            label.setID(this.getID());
            ((TextLabel)label).getFormats().setDecimalFormat(this.getDecimalFormat(node), TextFormats.DEFAULT_LOCALE);
            labels.add(label);
        }
    }

    @Override
    public void delete(Node node) {
        Labels labels = node.getAfferentBranch().getLabels();
        Label label = labels.get(this.getID());
        if (label != null) {
            labels.remove(label);
        }
    }

    @Override
    public TextLabel getDataElement(Node node) {
        Label l = node.getAfferentBranch().getLabels().get(this.getID());
        if (l instanceof TextLabel) {
            return (TextLabel)l;
        }
        return null;
    }

    public String toString() {
        return "Text labels with the ID \"" + this.getID() + "\"";
    }
}

