/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.nodebranchdata;

import info.bioinfweb.treegraph.document.AbstractPaintableElement;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.nodebranchdata.AbstractIDElementAdapter;
import info.bioinfweb.treegraph.document.tools.IDManager;
import java.text.DecimalFormat;

public class GeneralIDAdapter
extends AbstractIDElementAdapter {
    public GeneralIDAdapter(String id) {
        super(id);
    }

    @Override
    public String getName() {
        return "info.bioinfweb.treegraph.generalID";
    }

    @Override
    public boolean readOnly() {
        return true;
    }

    @Override
    public AbstractPaintableElement getDataElement(Node node) {
        Label l = node.getAfferentBranch().getLabels().get(this.id);
        if (l != null && l instanceof TextLabel) {
            return (TextLabel)l;
        }
        TextElementData data = null;
        data = node.getHiddenDataMap().get(this.id);
        if (data != null) {
            return node;
        }
        data = node.getAfferentBranch().getHiddenDataMap().get(this.id);
        if (data != null) {
            return node.getAfferentBranch();
        }
        return null;
    }

    @Override
    public TextElementData getData(Node node) {
        return IDManager.getDataByID(node, this.id);
    }

    @Override
    public boolean assignData(Node node, TextElementData data) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public DecimalFormat getDecimalFormat(Node node) {
        Label l = node.getAfferentBranch().getLabels().get(this.getID());
        if (l != null && l instanceof TextLabel) {
            return ((TextLabel)l).getFormats().getDecimalFormat();
        }
        return super.getDecimalFormat(node);
    }

    @Override
    protected void createData(Node node) {
        throw new UnsupportedOperationException("Creating new values is not supported by this adapter.");
    }

    public String toString() {
        return "All data with the ID \"" + this.getID() + "\"";
    }
}

