/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.nodebranchdata;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.nodebranchdata.AbstractNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;

public class BranchLengthAdapter
extends AbstractNodeBranchDataAdapter
implements NodeBranchDataAdapter {
    private static BranchLengthAdapter sharedInstance = null;

    public static BranchLengthAdapter getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new BranchLengthAdapter();
        }
        return sharedInstance;
    }

    @Override
    public String getName() {
        return "info.bioinfweb.treegraph.branchLength";
    }

    @Override
    public boolean decimalOnly() {
        return true;
    }

    @Override
    public boolean readOnly() {
        return false;
    }

    @Override
    public boolean isNewColumn() {
        return false;
    }

    @Override
    public boolean isDecimal(Node node) {
        return node.getAfferentBranch().hasLength();
    }

    @Override
    public boolean isEmpty(Node node) {
        return !node.getAfferentBranch().hasLength();
    }

    @Override
    public boolean isString(Node node) {
        return false;
    }

    @Override
    public void setDecimal(Node node, double value) {
        node.getAfferentBranch().setLength(value);
    }

    @Override
    public String getText(Node node) {
        Double decimal = this.getDecimal(node);
        if (Double.isNaN(decimal)) {
            return "";
        }
        return "" + decimal;
    }

    @Override
    public double getDecimal(Node node) throws NumberFormatException {
        if (node.hasAfferentBranch() && node.getAfferentBranch().hasLength()) {
            return node.getAfferentBranch().getLength();
        }
        return Double.NaN;
    }

    @Override
    public void setText(Node node, String value) throws NumberFormatException, UnsupportedOperationException {
        if (node.hasAfferentBranch()) {
            if (value != null && !value.equals("")) {
                node.getAfferentBranch().setLength(Math2.parseDouble(value));
            } else {
                node.getAfferentBranch().setLength(Double.NaN);
            }
        } else {
            throw new UnsupportedOperationException("This node does not have an afferent branch to store a branch length.");
        }
    }

    @Override
    public void delete(Node node) {
        if (node.hasAfferentBranch()) {
            node.getAfferentBranch().deleteLength();
        }
    }

    @Override
    public Branch getDataElement(Node node) {
        return node.getAfferentBranch();
    }

    @Override
    public TextElementData toTextElementData(Node node) {
        return new TextElementData(this.getDecimal(node));
    }

    public String toString() {
        return "Branch lengths";
    }
}

