/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.nodebranchdata;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.nodebranchdata.AbstractNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.TextElementDataAdapter;
import java.text.DecimalFormat;

public abstract class AbstractTextElementDataAdapter
extends AbstractNodeBranchDataAdapter
implements NodeBranchDataAdapter,
TextElementDataAdapter {
    private DecimalFormat defaultDecimalFormat;

    public AbstractTextElementDataAdapter() {
        this(DEFAULT_DECIMAL_FORMAT);
    }

    public AbstractTextElementDataAdapter(DecimalFormat defaultDecimalFormat) {
        this.defaultDecimalFormat = defaultDecimalFormat;
    }

    @Override
    public abstract TextElementData getData(Node var1);

    @Override
    public TextElementData toTextElementData(Node node) {
        TextElementData data = this.getData(node);
        if (data != null) {
            return data.clone();
        }
        return new TextElementData();
    }

    @Override
    public abstract boolean assignData(Node var1, TextElementData var2);

    public DecimalFormat getDecimalFormat(Node node) {
        return this.defaultDecimalFormat;
    }

    protected abstract void createData(Node var1);

    @Override
    public boolean decimalOnly() {
        return false;
    }

    @Override
    public boolean isNewColumn() {
        return false;
    }

    @Override
    public void delete(Node node) {
        this.getData(node).clear();
    }

    @Override
    public double getDecimal(Node node) {
        TextElementData d = this.getData(node);
        if (d != null) {
            return d.getDecimal();
        }
        return Double.NaN;
    }

    @Override
    public String getText(Node node) {
        TextElementData d = this.getData(node);
        if (d != null) {
            return d.getText();
        }
        return "";
    }

    @Override
    public boolean isDecimal(Node node) {
        TextElementData d = this.getData(node);
        if (d != null) {
            return d.isDecimal();
        }
        return false;
    }

    @Override
    public boolean isEmpty(Node node) {
        TextElementData d = this.getData(node);
        if (d != null) {
            return d.isEmpty();
        }
        return true;
    }

    @Override
    public boolean isString(Node node) {
        TextElementData d = this.getData(node);
        if (d != null) {
            return d.isString();
        }
        return false;
    }

    @Override
    public void setDecimal(Node node, double value) {
        this.createData(node);
        this.getData(node).setDecimal(value);
    }

    @Override
    public void setText(Node node, String value) {
        this.createData(node);
        this.getData(node).setText(value);
    }

    public void setType(Node node, boolean decimal) {
        if (this.isDecimal(node) && !decimal) {
            this.setText(node, this.getData(node).formatValue(this.getDecimalFormat(node)));
        } else if (this.isString(node) && decimal) {
            try {
                this.setDecimal(node, Math2.parseDouble(this.getText(node)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

