/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.nodebranchdata;

import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;

public abstract class AbstractNodeBranchDataAdapter
implements NodeBranchDataAdapter {
    public boolean equals(Object other) {
        return other != null && other.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().getCanonicalName().hashCode();
    }

    @Override
    public void setTextElementData(Node node, TextElementData data) {
        if (!this.readOnly()) {
            if (data.isDecimal()) {
                try {
                    this.setDecimal(node, data.getDecimal());
                }
                catch (NumberFormatException e) {
                    this.delete(node);
                }
            } else if (data.isString()) {
                this.setText(node, data.getText());
            } else {
                this.delete(node);
            }
        }
    }

    public static double calculateMaxNodeData(NodeBranchDataAdapter adapter, Node root) {
        double result = 0.0;
        if (!Double.isNaN(adapter.getDecimal(root))) {
            result = adapter.getDecimal(root);
        }
        int i = 0;
        while (i < root.getChildren().size()) {
            result = Math.max(result, AbstractNodeBranchDataAdapter.calculateMaxNodeData(adapter, root.getChildren().get(i)));
            ++i;
        }
        return result;
    }
}

