/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.xtg;

import info.bioinfweb.commons.io.XMLUtils;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.HiddenDataMap;
import info.bioinfweb.treegraph.document.IconLabel;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Labels;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Legends;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.PieChartLabel;
import info.bioinfweb.treegraph.document.ScaleBar;
import info.bioinfweb.treegraph.document.TextElement;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.format.BranchFormats;
import info.bioinfweb.treegraph.document.format.DistanceDimension;
import info.bioinfweb.treegraph.document.format.GlobalFormats;
import info.bioinfweb.treegraph.document.format.GraphicalLabelFormats;
import info.bioinfweb.treegraph.document.format.IconLabelFormats;
import info.bioinfweb.treegraph.document.format.LegendFormats;
import info.bioinfweb.treegraph.document.format.LegendStyle;
import info.bioinfweb.treegraph.document.format.LineFormats;
import info.bioinfweb.treegraph.document.format.Margin;
import info.bioinfweb.treegraph.document.format.PieChartLabelFormats;
import info.bioinfweb.treegraph.document.format.ScaleBarFormats;
import info.bioinfweb.treegraph.document.format.ScaleValue;
import info.bioinfweb.treegraph.document.format.TextFormats;
import info.bioinfweb.treegraph.document.io.AbstractDocumentWriter;
import info.bioinfweb.treegraph.document.io.DocumentWriter;
import info.bioinfweb.treegraph.document.io.ReadWriteParameterMap;
import info.bioinfweb.treegraph.document.io.xtg.XTGConstants;
import info.bioinfweb.treegraph.document.nodebranchdata.IDElementAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import java.awt.Color;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XTGWriter
extends AbstractDocumentWriter
implements XTGConstants,
DocumentWriter {
    public static final String STREAM_ENCODING = "UTF8";
    public static String XML_VERSION = "1.0";
    public static String XML_ENCODING = "UTF-8";
    private XMLStreamWriter writer = null;

    private String formatColorByte(int value) {
        String result = String.format("%x", value).toUpperCase();
        if (result.length() == 1) {
            result = "0" + result;
        }
        return result;
    }

    private String formatColor(Color color) {
        return "#" + this.formatColorByte(color.getRed()) + this.formatColorByte(color.getGreen()) + this.formatColorByte(color.getBlue());
    }

    private String formatTextStyle(TextFormats f) {
        String result = "";
        if (f.hasTextStyle(1)) {
            result = String.valueOf(result) + "b";
        }
        if (f.hasTextStyle(2)) {
            result = String.valueOf(result) + "i";
        }
        if (f.hasTextStyle(4)) {
            result = String.valueOf(result) + "u";
        }
        return result;
    }

    private void writeTextElementData(TextElementData data) throws XMLStreamException {
        if (!data.isEmpty()) {
            this.writer.writeAttribute(ATTR_TEXT.toString(), data.toString());
            this.writer.writeAttribute(ATTR_TEXT_IS_DECIMAL.toString(), "" + data.isDecimal());
        }
    }

    private void writeDistanceDimension(String name, DistanceDimension d) throws XMLStreamException {
        this.writer.writeStartElement(name);
        this.writer.writeAttribute(ATTR_WIDTH.toString(), "" + d.getWidth().getInMillimeters());
        this.writer.writeAttribute(ATTR_HEIGHT.toString(), "" + d.getHeight().getInMillimeters());
        this.writer.writeEndElement();
    }

    private void writeAdapter(Document document, NodeBranchDataAdapter adapter, String purpose) throws XMLStreamException {
        this.writer.writeStartElement("Adapter");
        this.writer.writeAttribute(ATTR_ADAPTER_NAME.toString(), adapter.getName());
        if (adapter instanceof IDElementAdapter) {
            this.writer.writeAttribute(ATTR_ADAPTER_ID.toString(), ((IDElementAdapter)adapter).getID());
        }
        this.writer.writeAttribute(ATTR_ADAPTER_PURPOSE.toString(), purpose);
        this.writer.writeEndElement();
    }

    private void writeNodeBranchDataAdapters(Document document) throws XMLStreamException {
        this.writer.writeStartElement("NodeBranchDataAdapters".toString());
        this.writeAdapter(document, document.getDefaultLeafAdapter(), "info.bioinfweb.treegraph.defaultLeavesAdapter");
        this.writeAdapter(document, document.getDefaultSupportAdapter(), "info.bioinfweb.treegraph.defaultSupportAdapter");
        this.writer.writeEndElement();
    }

    private void writeMargin(String name, Margin m) throws XMLStreamException {
        this.writer.writeStartElement(name);
        this.writer.writeAttribute(ATTR_LEFT.toString(), "" + m.getLeft().getInMillimeters());
        this.writer.writeAttribute(ATTR_TOP.toString(), "" + m.getTop().getInMillimeters());
        this.writer.writeAttribute(ATTR_RIGHT.toString(), "" + m.getRight().getInMillimeters());
        this.writer.writeAttribute(ATTR_BOTTOM.toString(), "" + m.getBottom().getInMillimeters());
        this.writer.writeEndElement();
    }

    private void writeGlobalFormats(GlobalFormats f) throws XMLStreamException {
        this.writer.writeStartElement("GlobalFormats".toString());
        this.writer.writeAttribute(ATTR_BG_COLOR.toString(), this.formatColor(f.getBackgroundColor()));
        this.writer.writeAttribute(ATTR_BRANCH_LENGTH_SCALE.toString(), "" + f.getBranchLengthScale().getInMillimeters());
        this.writer.writeAttribute(ATTR_SHOW_SCALE_BAR.toString(), "" + f.getShowScaleBar());
        this.writer.writeAttribute(ATTR_SHOW_ROOTED.toString(), "" + f.getShowRooted());
        this.writer.writeAttribute(ATTR_ALIGN_TO_SUBTREE.toString(), "" + f.getAlignLegendsToSubtree());
        this.writer.writeAttribute(ATTR_POSITION_LABELS_TO_LEFT.toString(), "" + f.getPositionLabelsToLeft());
        this.writeMargin("DocMargin".toString(), f.getDocumentMargin());
        this.writer.writeEndElement();
    }

    private void writeTextFormatsAttr(TextFormats f) throws XMLStreamException {
        this.writeTextFormatsAttr(f, "", true);
    }

    private void writeTextFormatsAttr(TextFormats f, String prefix, boolean includeTextHeight) throws XMLStreamException {
        this.writer.writeAttribute(String.valueOf(prefix) + ATTR_TEXT_COLOR.toString(), this.formatColor(f.getTextColor()));
        if (includeTextHeight) {
            this.writer.writeAttribute(String.valueOf(prefix) + ATTR_TEXT_HEIGHT.toString(), "" + f.getTextHeight().getInMillimeters());
        }
        this.writer.writeAttribute(String.valueOf(prefix) + ATTR_TEXT_STYLE.toString(), this.formatTextStyle(f));
        this.writer.writeAttribute(String.valueOf(prefix) + ATTR_FONT_FAMILY.toString(), f.getFontName());
        this.writer.writeAttribute(String.valueOf(prefix) + ATTR_DECIMAL_FORMAT, f.getDecimalFormat().toPattern());
        this.writer.writeAttribute(String.valueOf(prefix) + ATTR_LOCALE_LANG, f.getLocale().getLanguage());
        this.writer.writeAttribute(String.valueOf(prefix) + ATTR_LOCALE_COUNTRY, f.getLocale().getCountry());
        this.writer.writeAttribute(String.valueOf(prefix) + ATTR_LOCALE_VARIANT, f.getLocale().getVariant());
    }

    private void writeLineAttr(LineFormats f) throws XMLStreamException {
        this.writer.writeAttribute(ATTR_LINE_COLOR.toString(), this.formatColor(f.getLineColor()));
        this.writer.writeAttribute(ATTR_LINE_WIDTH.toString(), "" + f.getLineWidth().getInMillimeters());
    }

    private void writeLabelDimensions(GraphicalLabelFormats f) throws XMLStreamException {
        this.writer.writeAttribute(ATTR_LABEL_WIDTH.toString(), "" + f.getWidth().getInMillimeters());
        this.writer.writeAttribute(ATTR_LABEL_HEIGHT.toString(), "" + f.getHeight().getInMillimeters());
    }

    private void writeLabelBlock(Labels labels, boolean above) throws XMLStreamException {
        int lineNo = 0;
        while (lineNo < labels.lineCount(above)) {
            int lineIndex = 0;
            while (lineIndex < labels.labelCount(above, lineNo)) {
                GraphicalLabelFormats f;
                Label l = labels.get(above, lineNo, lineIndex);
                if (l instanceof TextLabel) {
                    this.writer.writeStartElement("TextLabel");
                    this.writeTextElementData(((TextElement)((Object)l)).getData());
                    this.writeTextFormatsAttr(((TextElement)((Object)l)).getFormats());
                } else if (l instanceof IconLabel) {
                    this.writer.writeStartElement("IconLabel");
                    f = ((IconLabel)l).getFormats();
                    this.writeLineAttr((LineFormats)((Object)f));
                    this.writeLabelDimensions(f);
                    this.writer.writeAttribute(ATTR_ICON.toString(), ((IconLabelFormats)f).getIcon());
                    this.writer.writeAttribute(ATTR_ICON_FILLED.toString(), "" + ((IconLabelFormats)f).getIconFilled());
                } else if (l instanceof PieChartLabel) {
                    this.writer.writeStartElement("PieChartLabel");
                    f = ((PieChartLabel)l).getFormats();
                    this.writeTextElementData(((TextElement)((Object)l)).getData());
                    this.writeTextFormatsAttr((TextFormats)((Object)f));
                    this.writeLineAttr((LineFormats)((Object)f));
                    this.writeLabelDimensions(f);
                    this.writer.writeAttribute(ATTR_SHOW_INTERNAL_LINES.toString(), "" + ((PieChartLabelFormats)f).isShowInternalLines());
                    this.writer.writeAttribute(ATTR_SHOW_NULL_LINES.toString(), "" + ((PieChartLabelFormats)f).isShowLinesForZero());
                    this.writer.writeAttribute(ATTR_SHOW_TITLE.toString(), "" + ((PieChartLabelFormats)f).isShowTitle());
                    this.writer.writeAttribute(ATTR_CAPTION_TYPE.toString(), ((PieChartLabelFormats)f).getCaptionsContentType().name());
                    this.writer.writeAttribute(ATTR_CAPTION_LINK_TYPE.toString(), ((PieChartLabelFormats)f).getCaptionsLinkType().name());
                } else {
                    throw new InternalError("Unsupported label of type " + l.getClass().getCanonicalName() + " found.");
                }
                this.writer.writeAttribute(ATTR_ID.toString(), l.getID());
                this.writer.writeAttribute(ATTR_LABEL_ABOVE.toString(), "" + l.getFormats().isAbove());
                this.writer.writeAttribute(ATTR_LINE_NO.toString(), "" + l.getFormats().getLineNumber());
                this.writer.writeAttribute(ATTR_LINE_POS.toString(), "" + l.getFormats().getLinePosition());
                this.writeMargin("LabelMargin".toString(), l.getFormats().getMargin());
                if (l instanceof PieChartLabel) {
                    PieChartLabel pieChartLabel = (PieChartLabel)l;
                    this.writer.writeStartElement("DataIds".toString());
                    this.writeTextFormatsAttr(pieChartLabel.getFormats().getCaptionsTextFormats(), "", false);
                    int i = 0;
                    while (i < pieChartLabel.getSectionDataList().size()) {
                        this.writer.writeStartElement("DataId".toString());
                        this.writer.writeAttribute(ATTR_PIE_COLOR.toString(), this.formatColor(pieChartLabel.getFormats().getPieColor(i)));
                        PieChartLabel.SectionData data = pieChartLabel.getSectionDataList().get(i);
                        this.writer.writeAttribute(ATTR_PIE_CAPTION.toString(), data.getCaption());
                        this.writer.writeCharacters(data.getValueColumnID());
                        this.writer.writeEndElement();
                        ++i;
                    }
                    this.writer.writeEndElement();
                }
                this.writer.writeEndElement();
                ++lineIndex;
            }
            ++lineNo;
        }
    }

    private void writeHiddenDataMap(HiddenDataMap m) throws XMLStreamException {
        Iterator<String> iterator = m.idIterator();
        while (iterator.hasNext()) {
            this.writer.writeStartElement("InvisibleData".toString());
            String key = iterator.next();
            this.writer.writeAttribute(ATTR_ID.toString(), key);
            this.writeTextElementData(m.get(key));
            this.writer.writeEndElement();
        }
    }

    private void writeSubtree(Node root) throws XMLStreamException {
        this.writer.writeStartElement("Node".toString());
        this.writeTextElementData(root.getData());
        if (root.hasUniqueName()) {
            this.writer.writeAttribute(ATTR_UNIQUE_NAME.toString(), root.getUniqueName());
        }
        this.writeTextFormatsAttr(root.getFormats());
        this.writeLineAttr(root.getFormats());
        this.writer.writeAttribute(ATTR_EDGE_RADIUS.toString(), "" + root.getFormats().getCornerRadius().getInMillimeters());
        this.writeMargin("LeafMargin".toString(), root.getFormats().getLeafMargin());
        if (root.hasAfferentBranch()) {
            Branch b = root.getAfferentBranch();
            BranchFormats f = b.getFormats();
            this.writer.writeStartElement("Branch".toString());
            if (b.hasLength()) {
                this.writer.writeAttribute(ATTR_BRANCH_LENGTH.toString(), "" + b.getLength());
            }
            this.writeLineAttr(f);
            this.writer.writeAttribute(ATTR_CONSTANT_WIDTH.toString(), "" + f.isConstantWidth());
            this.writer.writeAttribute(ATTR_MIN_BRANCH_LENGTH.toString(), "" + f.getMinLength().getInMillimeters());
            this.writer.writeAttribute(ATTR_MIN_SPACE_ABOVE.toString(), "" + f.getMinSpaceAbove().getInMillimeters());
            this.writer.writeAttribute(ATTR_MIN_SPACE_BELOW.toString(), "" + f.getMinSpaceBelow().getInMillimeters());
            this.writeLabelBlock(b.getLabels(), true);
            this.writeLabelBlock(b.getLabels(), false);
            this.writeHiddenDataMap(b.getHiddenDataMap());
            this.writer.writeEndElement();
        }
        this.writeHiddenDataMap(root.getHiddenDataMap());
        int i = 0;
        while (i < root.getChildren().size()) {
            this.writeSubtree(root.getChildren().get(i));
            ++i;
        }
        this.writer.writeEndElement();
    }

    private void writeScaleValue(String name, ScaleValue v) throws XMLStreamException {
        String s = "" + v.getStoredValue();
        s = v.isInScaleUnits() ? String.valueOf(s) + "u" : String.valueOf(s) + "mm";
        this.writer.writeAttribute(name, s);
    }

    private void writeScaleBar(ScaleBar sb) throws XMLStreamException {
        String align;
        ScaleBarFormats f = sb.getFormats();
        this.writer.writeStartElement("ScaleBar".toString());
        this.writeTextElementData(sb.getData());
        this.writeLineAttr(f);
        this.writeTextFormatsAttr(f);
        switch (f.getAlignment()) {
            case LEFT: {
                align = "left";
                break;
            }
            case RIGHT: {
                align = "right";
                break;
            }
            default: {
                align = "treeWidth";
            }
        }
        this.writer.writeAttribute(ATTR_SCALE_BAR_ALIGN.toString(), align);
        this.writer.writeAttribute(ATTR_SCALE_BAR_DISTANCE.toString(), "" + f.getTreeDistance().getInMillimeters());
        this.writeScaleValue(ATTR_SCALE_BAR_WIDTH.toString(), f.getWidth());
        this.writer.writeAttribute(ATTR_SCALE_BAR_HEIGHT.toString(), "" + f.getHeight().getInMillimeters());
        this.writer.writeAttribute(ATTR_SMALL_INTERVAL.toString(), "" + f.getSmallInterval());
        this.writer.writeAttribute(ATTR_LONG_INTERVAL.toString(), "" + f.getLongInterval());
        this.writer.writeAttribute(ATTR_SCALE_BAR_START.toString(), "" + f.isStartLeft());
        this.writer.writeAttribute(ATTR_SCALE_BAR_INCREASE.toString(), "" + f.isIncreasing());
        this.writer.writeEndElement();
    }

    private void writeAnchor(LegendFormats f, int no) throws XMLStreamException {
        Node anchor = f.getAnchor(no);
        if (anchor != null) {
            this.writer.writeAttribute("Anchor" + no, anchor.getUniqueName());
        }
    }

    private void writeLegends(Legends legends) throws XMLStreamException {
        int i = 0;
        while (i < legends.size()) {
            String orientation;
            Legend l = legends.get(i);
            LegendFormats f = l.getFormats();
            this.writer.writeStartElement("Legend".toString());
            this.writeTextElementData(l.getData());
            this.writeAnchor(f, 0);
            this.writeAnchor(f, 1);
            this.writer.writeAttribute(ATTR_LEGEND_POS.toString(), "" + f.getPosition());
            this.writer.writeAttribute(ATTR_MIN_TREE_DISTANCE.toString(), "" + f.getMinTreeDistance().getInMillimeters());
            this.writer.writeAttribute(ATTR_LEGEND_SPACING.toString(), "" + f.getSpacing().getInMillimeters());
            String style = "brace";
            if (f.getLegendStyle().equals((Object)LegendStyle.BRACKET)) {
                style = "bracket";
            }
            this.writer.writeAttribute(ATTR_LEGEND_STYLE.toString(), style);
            switch (f.getOrientation()) {
                case DOWN: {
                    orientation = "down";
                    break;
                }
                case HORIZONTAL: {
                    orientation = "horizontal";
                    break;
                }
                default: {
                    orientation = "up";
                }
            }
            this.writer.writeAttribute(ATTR_TEXT_ORIENTATION.toString(), orientation);
            this.writeLineAttr(f);
            this.writer.writeAttribute(ATTR_EDGE_RADIUS.toString(), "" + f.getCornerRadius().getInMillimeters());
            this.writeTextFormatsAttr(f);
            this.writeMargin("LegendMargin".toString(), f.getMargin());
            this.writer.writeEndElement();
            ++i;
        }
    }

    @Override
    public void write(Document document, OutputStream stream, ReadWriteParameterMap properties) throws Exception {
        try {
            this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(stream, STREAM_ENCODING);
            try {
                this.writer.writeStartDocument(XML_ENCODING, XML_VERSION);
                this.writer.setDefaultNamespace("http://bioinfweb.info/xmlns/xtg");
                this.writer.writeStartElement("TreegraphDocument".toString());
                XMLUtils.writeNamespaceXSDAttr(this.writer, "http://bioinfweb.info/xmlns/xtg", "http://bioinfweb.info/xmlns/xtg/" + VERSION + ".xsd");
                this.writeGlobalFormats(document.getTree().getFormats());
                this.writeNodeBranchDataAdapters(document);
                this.writer.writeStartElement("Tree".toString());
                if (!document.getTree().isEmpty()) {
                    this.writeSubtree(document.getTree().getPaintStart());
                }
                this.writeScaleBar(document.getTree().getScaleBar());
                this.writeLegends(document.getTree().getLegends());
                this.writer.writeEndElement();
                this.writer.writeEndElement();
                this.writer.writeEndDocument();
            }
            finally {
                this.writer.close();
            }
        }
        finally {
            stream.close();
        }
    }
}

