/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.xtg;

import info.bioinfweb.commons.io.FormatVersion;
import info.bioinfweb.commons.io.InvalidXSDPathException;
import info.bioinfweb.commons.io.XMLUtils;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.HiddenDataMap;
import info.bioinfweb.treegraph.document.IconLabel;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Labels;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Legends;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.PieChartLabel;
import info.bioinfweb.treegraph.document.ScaleBar;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.format.BranchFormats;
import info.bioinfweb.treegraph.document.format.DistanceDimension;
import info.bioinfweb.treegraph.document.format.DistanceValue;
import info.bioinfweb.treegraph.document.format.GlobalFormats;
import info.bioinfweb.treegraph.document.format.GraphicalLabelFormats;
import info.bioinfweb.treegraph.document.format.IconLabelFormats;
import info.bioinfweb.treegraph.document.format.LabelFormats;
import info.bioinfweb.treegraph.document.format.LegendFormats;
import info.bioinfweb.treegraph.document.format.LegendStyle;
import info.bioinfweb.treegraph.document.format.LineFormats;
import info.bioinfweb.treegraph.document.format.Margin;
import info.bioinfweb.treegraph.document.format.NodeFormats;
import info.bioinfweb.treegraph.document.format.PieChartLabelCaptionContentType;
import info.bioinfweb.treegraph.document.format.PieChartLabelCaptionLinkType;
import info.bioinfweb.treegraph.document.format.PieChartLabelFormats;
import info.bioinfweb.treegraph.document.format.ScaleBarAlignment;
import info.bioinfweb.treegraph.document.format.ScaleBarFormats;
import info.bioinfweb.treegraph.document.format.ScaleValue;
import info.bioinfweb.treegraph.document.format.TextFormats;
import info.bioinfweb.treegraph.document.format.TextOrientation;
import info.bioinfweb.treegraph.document.io.AbstractDocumentReader;
import info.bioinfweb.treegraph.document.io.DocumentIterator;
import info.bioinfweb.treegraph.document.io.SingleDocumentIterator;
import info.bioinfweb.treegraph.document.io.xtg.XTGConstants;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.factory.NodeBranchDataAdapterFactory;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import java.io.BufferedInputStream;
import java.text.DecimalFormat;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XTGReader
extends AbstractDocumentReader
implements XTGConstants {
    private XMLEventReader reader;

    public XTGReader() {
        super(true);
    }

    private void readDistanceValueAttr(DistanceValue value, StartElement element, QName name) {
        Attribute attr = element.getAttributeByName(name);
        if (attr != null) {
            try {
                value.setInMillimeters(Float.parseFloat(attr.getValue()));
            }
            catch (NumberFormatException e) {
                this.loadLogger.addWarning("The distance value attribute \"" + attr.getValue() + "\" is malformed. A default " + "value was used instead.");
            }
        }
    }

    private void readTextElementDataAttr(TextElementData data, StartElement element) {
        String text = XMLUtils.readStringAttr(element, ATTR_TEXT, null);
        if (text == null) {
            data.clear();
        } else if (XMLUtils.readBooleanAttr(element, ATTR_TEXT_IS_DECIMAL, false)) {
            try {
                data.setDecimal(Double.parseDouble(text));
            }
            catch (NumberFormatException e) {
                this.loadLogger.addWarning("The decimal value attribute \"" + text + "\" is malformed. It was imported as a " + "textual value instead.");
                data.setText(text);
            }
        } else {
            data.setText(text);
        }
    }

    private void readDistanceDimensionAttr(DistanceDimension d, StartElement element) {
        this.readDistanceValueAttr(d.getWidth(), element, ATTR_WIDTH);
        this.readDistanceValueAttr(d.getHeight(), element, ATTR_HEIGHT);
    }

    private void readAdapter(StartElement element) throws XMLStreamException {
        String adapterName = XMLUtils.readStringAttr(element, ATTR_ADAPTER_NAME, null);
        String adapterPurpose = XMLUtils.readStringAttr(element, ATTR_ADAPTER_PURPOSE, null);
        if (adapterName != null) {
            NodeBranchDataAdapter adapter = NodeBranchDataAdapterFactory.getInstance().newAdapterInstance(adapterName, XMLUtils.readStringAttr(element, ATTR_ADAPTER_ID, ""));
            if (adapter == null) {
                this.loadLogger.addWarning("No NodeBranchDataAdapter with the name \"" + adapterName + "\" could be created. Probably you are not using the most recent version of TreeGraph 2.");
            } else if ("info.bioinfweb.treegraph.defaultLeavesAdapter".equals(adapterPurpose) || "info.bioinfweb.treegraph.defaultLeafsAdapter".equals(adapterPurpose)) {
                this.document.setDefaultLeafAdapter(adapter);
            } else if ("info.bioinfweb.treegraph.defaultSupportAdapter".equals(adapterPurpose)) {
                this.document.setDefaultSupportAdapter(adapter);
            } else if (adapterPurpose == null) {
                this.loadLogger.addWarning("An adapter could not be read, beacuse no purpose attribute was specified.");
            } else {
                this.loadLogger.addWarning("No default adapter for the purpose \"" + adapterPurpose + "\" could be written to the document. Probably you are not using the most recent version of TreeGraph 2.");
            }
        } else {
            this.loadLogger.addWarning("An adapter could not be read, beacuse no name attribute was specified.");
        }
        this.reachElementEnd(this.reader, "XML elements under <Adapter>");
    }

    private void readNodeBranchDataAdapters(StartElement rootElement) throws XMLStreamException {
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().getLocalPart().equals("Adapter")) {
                    this.readAdapter(element);
                } else {
                    this.reachElementEnd(this.reader, element);
                }
            }
            event = this.reader.nextEvent();
        }
    }

    private void readMargin(Margin m, StartElement element) throws XMLStreamException {
        this.readDistanceValueAttr(m.getLeft(), element, ATTR_LEFT);
        this.readDistanceValueAttr(m.getTop(), element, ATTR_TOP);
        this.readDistanceValueAttr(m.getRight(), element, ATTR_RIGHT);
        this.readDistanceValueAttr(m.getBottom(), element, ATTR_BOTTOM);
        this.reachElementEnd(this.reader, "XML elements under <LabelMargin>");
    }

    private void readGlobalFormats(StartElement rootElement) throws XMLStreamException {
        GlobalFormats f = this.document.getTree().getFormats();
        f.setBackgroundColor(XMLUtils.readColorAttr(rootElement, ATTR_BG_COLOR, f.getBackgroundColor()));
        this.readDistanceValueAttr(f.getBranchLengthScale(), rootElement, ATTR_BRANCH_LENGTH_SCALE);
        f.setShowScaleBar(XMLUtils.readBooleanAttr(rootElement, ATTR_SHOW_SCALE_BAR, f.getShowScaleBar()));
        f.setShowRooted(XMLUtils.readBooleanAttr(rootElement, ATTR_SHOW_ROOTED, f.getShowRooted()));
        f.setAlignLegendsToSubtree(XMLUtils.readBooleanAttr(rootElement, ATTR_ALIGN_TO_SUBTREE, false));
        f.setAlignLegendsToSubtree(XMLUtils.readBooleanAttr(rootElement, ATTR_POSITION_LABELS_TO_LEFT, f.getPositionLabelsToLeft()));
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().getLocalPart().equals("DocMargin")) {
                    this.readMargin(f.getDocumentMargin(), element);
                } else {
                    this.reachElementEnd(this.reader, element);
                }
            }
            event = this.reader.nextEvent();
        }
    }

    private void readTextStyleAttr(TextFormats f, StartElement element) {
        Attribute attr = element.getAttributeByName(ATTR_TEXT_STYLE);
        if (attr != null) {
            String str = attr.getValue().toLowerCase();
            f.setTextStyle(0);
            if (str.contains("b")) {
                f.addTextStyle(1);
            }
            if (str.contains("i")) {
                f.addTextStyle(2);
            }
            if (str.contains("u")) {
                f.addTextStyle(4);
            }
        }
    }

    private void readDecimalFormat(TextFormats f, StartElement element, String prefix) {
        String variant;
        String country;
        DecimalFormat format = new DecimalFormat(XMLUtils.readStringAttr(element, new QName(String.valueOf(prefix) + ATTR_DECIMAL_FORMAT.toString()), "0.0#####"));
        String lang = XMLUtils.readStringAttr(element, new QName(String.valueOf(prefix) + ATTR_LOCALE_LANG), null);
        Locale locale = lang == null ? TextFormats.DEFAULT_LOCALE : ((country = XMLUtils.readStringAttr(element, new QName(String.valueOf(prefix) + ATTR_LOCALE_COUNTRY), null)) == null ? new Locale(lang) : ((variant = XMLUtils.readStringAttr(element, new QName(String.valueOf(prefix) + ATTR_LOCALE_VARIANT), null)) == null ? new Locale(lang, country) : new Locale(lang, country, variant)));
        f.setDecimalFormat(format, locale);
    }

    private void readTextFormatsAttr(TextFormats f, StartElement element, String prefix) {
        f.setTextColor(XMLUtils.readColorAttr(element, new QName(String.valueOf(prefix) + ATTR_TEXT_COLOR.toString()), f.getTextColor()));
        this.readDistanceValueAttr(f.getTextHeight(), element, new QName(String.valueOf(prefix) + ATTR_TEXT_HEIGHT.toString()));
        this.readTextStyleAttr(f, element);
        f.setFontName(XMLUtils.readStringAttr(element, new QName(String.valueOf(prefix) + ATTR_FONT_FAMILY.toString()), f.getFontName()));
        this.readDecimalFormat(f, element, prefix);
    }

    private void readLineAttr(LineFormats f, StartElement element) {
        this.readDistanceValueAttr(f.getLineWidth(), element, ATTR_LINE_WIDTH);
        f.setLineColor(XMLUtils.readColorAttr(element, ATTR_LINE_COLOR, f.getLineColor()));
    }

    private void readBranch(StartElement rootElement, Branch b) throws XMLStreamException {
        BranchFormats f = b.getFormats();
        b.setLength(XMLUtils.readDoubleAttr(rootElement, ATTR_BRANCH_LENGTH, b.getLength()));
        this.readLineAttr(f, rootElement);
        this.readDistanceValueAttr(f.getMinLength(), rootElement, ATTR_MIN_BRANCH_LENGTH);
        this.readDistanceValueAttr(f.getMinSpaceAbove(), rootElement, ATTR_MIN_SPACE_ABOVE);
        this.readDistanceValueAttr(f.getMinSpaceBelow(), rootElement, ATTR_MIN_SPACE_BELOW);
        f.setConstantWidth(XMLUtils.readBooleanAttr(rootElement, ATTR_CONSTANT_WIDTH, f.isConstantWidth()));
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().getLocalPart().equals("TextLabel")) {
                    this.readTextLabel(element, b.getLabels());
                } else if (element.getName().getLocalPart().equals("IconLabel")) {
                    this.readIconLabel(element, b.getLabels());
                } else if (element.getName().getLocalPart().equals("PieChartLabel")) {
                    this.readPieChartLabel(element, b.getLabels());
                } else if (element.getName().getLocalPart().equals("InvisibleData")) {
                    this.readHiddenData(element, b.getHiddenDataMap());
                } else {
                    this.reachElementEnd(this.reader, element);
                }
            }
            event = this.reader.nextEvent();
        }
    }

    private void readPieChartIDs(StartElement rootElement, PieChartLabel l) throws XMLStreamException {
        PieChartLabelFormats f = l.getFormats();
        this.readTextFormatsAttr(f.getCaptionsTextFormats(), rootElement, "");
        XMLEvent event = this.reader.nextEvent();
        int index = 0;
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().getLocalPart().equals("DataId")) {
                    f.setPieColor(index, XMLUtils.readColorAttr(element, ATTR_PIE_COLOR, f.getPieColor(index)));
                    String caption = XMLUtils.readStringAttr(element, ATTR_PIE_CAPTION, "");
                    l.getSectionDataList().add(new PieChartLabel.SectionData(XMLUtils.readCharactersAsString(this.reader), caption));
                    this.reachElementEnd(this.reader, element);
                    ++index;
                } else {
                    this.reachElementEnd(this.reader, element);
                }
            }
            event = this.reader.nextEvent();
        }
    }

    private void readLabelData(StartElement rootElement, Label l) throws XMLStreamException {
        l.setID(XMLUtils.readStringAttr(rootElement, ATTR_ID, l.getID()));
        LabelFormats f = l.getFormats();
        f.setAbove(XMLUtils.readBooleanAttr(rootElement, ATTR_LABEL_ABOVE, f.isAbove()));
        f.setLineNumber(XMLUtils.readIntAttr(rootElement, ATTR_LINE_NO, f.getLineNumber()));
        f.setLinePosition(XMLUtils.readDoubleAttr(rootElement, ATTR_LINE_POS, f.getLinePosition()));
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().getLocalPart().equals("LabelMargin")) {
                    this.readMargin(f.getMargin(), element);
                } else if (element.getName().getLocalPart().equals("DataIds") && l instanceof PieChartLabel) {
                    this.readPieChartIDs(element, (PieChartLabel)l);
                } else {
                    this.reachElementEnd(this.reader, element);
                }
            }
            event = this.reader.nextEvent();
        }
    }

    private void readTextLabel(StartElement rootElement, Labels labels) throws XMLStreamException {
        TextLabel l = new TextLabel(null);
        this.readTextElementDataAttr(l.getData(), rootElement);
        this.readTextFormatsAttr(l.getFormats(), rootElement, "");
        this.readLabelData(rootElement, l);
        labels.add(l);
    }

    private void readGraphicalLabelDimensions(GraphicalLabelFormats f, StartElement element) {
        this.readDistanceValueAttr(f.getWidth(), element, ATTR_LABEL_WIDTH);
        this.readDistanceValueAttr(f.getHeight(), element, ATTR_LABEL_HEIGHT);
    }

    private void readIconLabel(StartElement rootElement, Labels labels) throws XMLStreamException {
        IconLabel l = new IconLabel(null);
        IconLabelFormats f = l.getFormats();
        this.readLineAttr(f, rootElement);
        f.setIcon(XMLUtils.readStringAttr(rootElement, ATTR_ICON, f.getIcon()));
        if (this.document.getVersion() == null || VERSION.geraterThan(this.document.getVersion())) {
            this.readDistanceValueAttr(f.getWidth(), rootElement, ATTR_ICON_WIDTH);
            this.readDistanceValueAttr(f.getHeight(), rootElement, ATTR_ICON_HEIGHT);
        } else {
            this.readGraphicalLabelDimensions(f, rootElement);
        }
        f.setIconFilled(XMLUtils.readBooleanAttr(rootElement, ATTR_ICON_FILLED, f.getIconFilled()));
        this.readLabelData(rootElement, l);
        labels.add(l);
    }

    private void readPieChartLabel(StartElement rootElement, Labels labels) throws XMLStreamException {
        PieChartLabel l = new PieChartLabel(null);
        PieChartLabelFormats f = l.getFormats();
        this.readTextElementDataAttr(l.getData(), rootElement);
        this.readTextFormatsAttr(f, rootElement, "");
        this.readLineAttr(f, rootElement);
        this.readGraphicalLabelDimensions(f, rootElement);
        f.setShowInternalLines(XMLUtils.readBooleanAttr(rootElement, ATTR_SHOW_INTERNAL_LINES, f.isShowInternalLines()));
        f.setShowLinesForZero(XMLUtils.readBooleanAttr(rootElement, ATTR_SHOW_NULL_LINES, f.isShowLinesForZero()));
        f.setShowTitle(XMLUtils.readBooleanAttr(rootElement, ATTR_SHOW_TITLE, f.isShowTitle()));
        f.setCaptionsContentType(PieChartLabelCaptionContentType.valueOf(XMLUtils.readStringAttr(rootElement, ATTR_CAPTION_TYPE, f.getCaptionsContentType().name())));
        f.setCaptionsLinkType(PieChartLabelCaptionLinkType.valueOf(XMLUtils.readStringAttr(rootElement, ATTR_CAPTION_LINK_TYPE, f.getCaptionsLinkType().name())));
        this.readLabelData(rootElement, l);
        labels.add(l);
    }

    private void readHiddenData(StartElement element, HiddenDataMap list) throws XMLStreamException {
        String id = XMLUtils.readStringAttr(element, ATTR_ID, null);
        if (id != null) {
            TextElementData data = new TextElementData();
            this.readTextElementDataAttr(data, element);
            list.put(id, data);
        }
        this.reachElementEnd(this.reader, "XML elements under <InvisibleData>");
    }

    private Node readSubtree(StartElement rootElement) throws XMLStreamException {
        Node result = Node.newInstanceWithBranch();
        NodeFormats f = result.getFormats();
        this.readTextElementDataAttr(result.getData(), rootElement);
        result.setUniqueName(XMLUtils.readStringAttr(rootElement, ATTR_UNIQUE_NAME, result.getUniqueName()));
        this.readTextFormatsAttr(result.getFormats(), rootElement, "");
        this.readLineAttr(f, rootElement);
        this.readDistanceValueAttr(f.getCornerRadius(), rootElement, ATTR_EDGE_RADIUS);
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().getLocalPart().equals("Branch")) {
                    this.readBranch(element, result.getAfferentBranch());
                } else if (element.getName().getLocalPart().equals("TextLabel")) {
                    this.readTextLabel(element, result.getAfferentBranch().getLabels());
                } else if (element.getName().getLocalPart().equals("InvisibleData")) {
                    this.readHiddenData(element, result.getHiddenDataMap());
                } else if (element.getName().getLocalPart().equals("LeafMargin")) {
                    this.readMargin(f.getLeafMargin(), element);
                } else if (element.getName().getLocalPart().equals("Node")) {
                    Node subelement = this.readSubtree(element);
                    subelement.setParent(result);
                    result.getChildren().add(subelement);
                } else {
                    this.reachElementEnd(this.reader, element);
                }
            }
            event = this.reader.nextEvent();
        }
        return result;
    }

    private void readScaleValueAttr(ScaleValue value, StartElement element, QName name) {
        Attribute attr = element.getAttributeByName(name);
        if (attr != null) {
            String text = attr.getValue();
            if (text.endsWith("u")) {
                value.setInMillimeters(Float.parseFloat(text.substring(0, text.length() - "u".length())));
            } else {
                value.setInMillimeters(Float.parseFloat(text.substring(0, text.length() - "mm".length())));
            }
        }
    }

    private void readScaleBar(StartElement element, ScaleBar s) throws XMLStreamException {
        ScaleBarFormats f = s.getFormats();
        s.getData().setText(XMLUtils.readStringAttr(element, ATTR_TEXT, s.getData().getText()));
        this.readLineAttr(f, element);
        this.readTextFormatsAttr(f, element, "");
        String align = XMLUtils.readStringAttr(element, ATTR_SCALE_BAR_ALIGN, "left");
        if (align.equals("left")) {
            f.setAlignment(ScaleBarAlignment.LEFT);
        } else if (align.equals("right")) {
            f.setAlignment(ScaleBarAlignment.RIGHT);
        } else {
            f.setAlignment(ScaleBarAlignment.TREE_WIDTH);
        }
        this.readDistanceValueAttr(f.getTreeDistance(), element, ATTR_SCALE_BAR_DISTANCE);
        this.readScaleValueAttr(f.getWidth(), element, ATTR_SCALE_BAR_WIDTH);
        this.readDistanceValueAttr(f.getHeight(), element, ATTR_SCALE_BAR_HEIGHT);
        f.setSmallInterval(XMLUtils.readFloatAttr(element, ATTR_SMALL_INTERVAL, f.getSmallInterval()));
        f.setLongInterval(XMLUtils.readIntAttr(element, ATTR_LONG_INTERVAL, f.getLongInterval()));
        f.setStartLeft(XMLUtils.readBooleanAttr(element, ATTR_SCALE_BAR_START, f.isStartLeft()));
        f.setIncreasing(XMLUtils.readBooleanAttr(element, ATTR_SCALE_BAR_INCREASE, f.isIncreasing()));
        this.reachElementEnd(this.reader, "XML elements under <ScaleBar>");
    }

    private void readAnchor(StartElement rootElement, Legend l, int no) {
        String uniqueName = XMLUtils.readStringAttr(rootElement, new QName("Anchor" + no), null);
        if (uniqueName != null) {
            Node anchor = this.document.getTree().getNodeByUniqueName(uniqueName.toLowerCase());
            if (anchor == null) {
                anchor = this.document.getTree().getPaintStart();
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "The legend \"" + l.getData() + "\" refers to a node with the unique name \"" + uniqueName + "\" as anchor which does not exist in this document. The root node was set as the new achor.\n(This problem is probably the result of an incorrect manual edit of the document.)", "Missing anchor", 2);
            }
            l.getFormats().setAnchor(no, anchor);
        }
    }

    private void readLegend(StartElement rootElement, Legends legends) throws XMLStreamException {
        String orientation;
        Legend legend = new Legend(legends);
        LegendFormats f = legend.getFormats();
        this.readTextElementDataAttr(legend.getData(), rootElement);
        this.readAnchor(rootElement, legend, 0);
        this.readAnchor(rootElement, legend, 1);
        String style = XMLUtils.readStringAttr(rootElement, ATTR_LEGEND_STYLE, "bracket");
        if (style.equals("brace")) {
            f.setLegendStyle(LegendStyle.BRACE);
        }
        if ((orientation = XMLUtils.readStringAttr(rootElement, ATTR_TEXT_ORIENTATION, "up")).equals("down")) {
            f.setOrientation(TextOrientation.DOWN);
        } else if (orientation.equals("horizontal")) {
            f.setOrientation(TextOrientation.HORIZONTAL);
        } else {
            f.setOrientation(TextOrientation.UP);
        }
        f.setPosition(XMLUtils.readIntAttr(rootElement, ATTR_LEGEND_POS, f.getPosition()));
        this.readDistanceValueAttr(f.getMinTreeDistance(), rootElement, ATTR_MIN_TREE_DISTANCE);
        this.readDistanceValueAttr(f.getSpacing(), rootElement, ATTR_LEGEND_SPACING);
        this.readLineAttr(f, rootElement);
        this.readTextFormatsAttr(f, rootElement, "");
        this.readDistanceValueAttr(f.getCornerRadius(), rootElement, ATTR_EDGE_RADIUS);
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().getLocalPart().equals("LegendMargin")) {
                    this.readMargin(f.getMargin(), element);
                } else {
                    this.reachElementEnd(this.reader, element);
                }
            }
            event = this.reader.nextEvent();
        }
        legends.insert(legend);
    }

    private void readTree(StartElement rootElement) throws XMLStreamException {
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().getLocalPart().equals("Node")) {
                    this.document.getTree().setPaintStart(this.readSubtree(element));
                    this.document.getTree().assignUniqueNames();
                } else if (element.getName().getLocalPart().equals("ScaleBar")) {
                    this.readScaleBar(element, this.document.getTree().getScaleBar());
                } else if (element.getName().getLocalPart().equals("Legend")) {
                    this.readLegend(element, this.document.getTree().getLegends());
                } else {
                    this.reachElementEnd(this.reader, element);
                }
            }
            event = this.reader.nextEvent();
        }
        this.document.getTree().updateElementSet();
    }

    private void readDocument(StartElement rootElement) throws XMLStreamException {
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().getLocalPart().equals("NodeBranchDataAdapters")) {
                    this.readNodeBranchDataAdapters(element);
                } else if (element.getName().getLocalPart().equals("GlobalFormats")) {
                    this.readGlobalFormats(element);
                } else if (element.getName().getLocalPart().equals("Tree")) {
                    this.readTree(element);
                } else {
                    this.reachElementEnd(this.reader, element);
                }
            }
            event = this.reader.nextEvent();
        }
    }

    private void checkNameSpace(StartElement element) {
        String namespace = element.getNamespaceContext().getNamespaceURI("");
        if (namespace == null) {
            this.loadLogger.addWarning("No XML namespace declared. Assuming http://bioinfweb.info/xmlns/xtg.");
        } else if (!namespace.equals("http://bioinfweb.info/xmlns/xtg")) {
            this.loadLogger.addWarning("Declared namespace is not http://bioinfweb.info/xmlns/xtg. Trying to read as http://bioinfweb.info/xmlns/xtg anyway.");
        }
        try {
            FormatVersion version = XMLUtils.extractFormatVersion(element);
            if (version == null) {
                this.loadLogger.addWarning("No XML schema location found. Assuming \"" + FULL_SCHEMA_LOCATION + "\".");
            } else {
                this.document.setVersion(version);
                if (VERSION.compareTo(version) < 0) {
                    this.loadLogger.addWarning("The source file is version " + version + ", whereas this application only " + "supports XTG version " + VERSION + " or below. Some elements might not be imported correctly. You " + "should consider to upgrade to the latest version of TreeGraph 2.");
                }
            }
        }
        catch (InvalidXSDPathException e) {
            this.loadLogger.addWarning("The XML schema location is malformed. Assuming \"" + FULL_SCHEMA_LOCATION + "\".");
        }
    }

    @Override
    public Document readDocument(BufferedInputStream stream) throws Exception {
        this.document = null;
        this.reader = XMLInputFactory.newInstance().createXMLEventReader(stream);
        try {
            while (this.reader.hasNext()) {
                XMLEvent event = this.reader.nextEvent();
                switch (event.getEventType()) {
                    case 7: {
                        this.document = this.createEmptyDocument();
                        break;
                    }
                    case 8: {
                        this.reader.close();
                        Document document = this.document;
                        return document;
                    }
                    case 1: {
                        StartElement element = event.asStartElement();
                        if (element.getName().getLocalPart().equals("TreegraphDocument")) {
                            this.checkNameSpace(element);
                            this.readDocument(element);
                            break;
                        }
                        this.reachElementEnd(this.reader, element);
                    }
                }
            }
        }
        finally {
            this.reader.close();
            stream.close();
        }
        return null;
    }

    @Override
    public DocumentIterator createIterator(BufferedInputStream stream) throws Exception {
        return new SingleDocumentIterator(this.read(stream));
    }
}

