/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.tgf;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.format.DistanceValue;
import info.bioinfweb.treegraph.document.format.LabelFormats;
import info.bioinfweb.treegraph.document.format.NodeFormats;
import info.bioinfweb.treegraph.document.io.AbstractDocumentReader;
import info.bioinfweb.treegraph.document.io.DocumentIterator;
import java.io.BufferedInputStream;
import java.util.HashMap;

public class TGFReader
extends AbstractDocumentReader {
    private static final int SECOUND_LINE_POS = 100;
    private HashMap<String, LabelFormats> labelFormats = null;
    private NodeFormats leafFormats = null;
    private DistanceValue lineWidth = new DistanceValue();
    private DistanceValue cornerRadius = new DistanceValue();

    public TGFReader() {
        super(false);
    }

    private HashMap<String, LabelFormats> initLabelFormats() {
        HashMap<String, LabelFormats> result = new HashMap<String, LabelFormats>();
        int lineNo = 0;
        while (lineNo <= 1) {
            LabelFormats f = new LabelFormats(null);
            f.setLineNumber(lineNo);
            result.put("u" + (2 * lineNo + 1), f);
            f = new LabelFormats(null);
            f.setLinePosition(100.0);
            result.put("u" + (2 * lineNo + 2), f);
            f = new LabelFormats(null);
            f.setAbove(false);
            f.setLineNumber(lineNo);
            result.put("d" + (2 * lineNo + 1), f);
            f = new LabelFormats(null);
            f.setAbove(false);
            f.setLinePosition(100.0);
            result.put("d" + (2 * lineNo + 2), f);
            ++lineNo;
        }
        return result;
    }

    @Override
    public Document readDocument(BufferedInputStream stream) throws Exception {
        this.labelFormats = this.initLabelFormats();
        this.leafFormats = new NodeFormats();
        this.lineWidth.setInMillimeters(0.3f);
        this.cornerRadius.setInMillimeters(1.0f);
        return null;
    }

    @Override
    public DocumentIterator createIterator(BufferedInputStream stream) throws Exception {
        return null;
    }
}

