/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.phyloxml;

import info.bioinfweb.commons.io.XMLUtils;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.HiddenDataMap;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.io.AbstractDocumentReader;
import info.bioinfweb.treegraph.document.io.DocumentIterator;
import info.bioinfweb.treegraph.document.io.newick.BranchLengthsScaler;
import info.bioinfweb.treegraph.document.io.phyloxml.PhyloXMLConstants;
import info.bioinfweb.treegraph.document.undo.format.AutoPositionLabelsEdit;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.util.Vector;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class PhyloXMLReader
extends AbstractDocumentReader
implements PhyloXMLConstants {
    private XMLEventReader reader;
    private Vector<String> names = new Vector();
    private Vector<Tree> phylogenies = new Vector();
    private BranchLengthsScaler branchLengthsScaler = new BranchLengthsScaler();

    public PhyloXMLReader() {
        super(false);
    }

    private int readColorValue() throws XMLStreamException {
        return Math.max(0, Math.min(255, Short.parseShort(this.reader.nextEvent().asCharacters().getData())));
    }

    private Color readColor() throws XMLStreamException {
        int red = 0;
        int green = 0;
        int blue = 0;
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().equals(TAG_COLOR_RED)) {
                    red = this.readColorValue();
                    this.reader.nextEvent();
                } else if (element.getName().equals(TAG_COLOR_GREEN)) {
                    green = this.readColorValue();
                    this.reader.nextEvent();
                } else if (element.getName().equals(TAG_COLOR_BLUE)) {
                    blue = this.readColorValue();
                    this.reader.nextEvent();
                } else {
                    XMLUtils.reachElementEnd(this.reader);
                }
            }
            event = this.reader.nextEvent();
        }
        return new Color(red, green, blue);
    }

    private void storeHiddenData(HiddenDataMap map, String keyPrefix, StartElement element) throws XMLStreamException {
        TextElementData data;
        String value = this.reader.nextEvent().asCharacters().getData();
        try {
            data = new TextElementData(Double.parseDouble(value));
        }
        catch (NumberFormatException e) {
            data = new TextElementData(value);
        }
        map.put("phyloXML." + keyPrefix + element.getName().getLocalPart(), data);
        this.reader.nextEvent();
    }

    private void readTaxonomy(Node node) throws XMLStreamException {
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().equals(TAG_CODE) || element.getName().equals(TAG_SCIENTIFIC_NAME) || element.getName().equals(TAG_RANK) || element.getName().equals(TAG_COMMON_NAME) || element.getName().equals(TAG_AUTHORITY) || element.getName().equals(TAG_SYNONYM)) {
                    this.storeHiddenData(node.getHiddenDataMap(), String.valueOf(TAG_TAXONOMY.getLocalPart().toString()) + ".", element);
                } else {
                    XMLUtils.reachElementEnd(this.reader);
                }
            }
            event = this.reader.nextEvent();
        }
    }

    private void readSequence(StartElement rootElement, Node node) throws XMLStreamException {
        String type = XMLUtils.readStringAttr(rootElement, ATTR_TYPE, null);
        if (type != null) {
            node.getHiddenDataMap().put("phyloXML." + TAG_SEQUENCE.getLocalPart().toString() + "." + ATTR_TYPE.toString(), new TextElementData(type));
        }
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().equals(TAG_SYMBOL) || element.getName().equals(TAG_ACCESSION) || element.getName().equals(TAG_NAME) || element.getName().equals(TAG_LOCATION)) {
                    this.storeHiddenData(node.getHiddenDataMap(), String.valueOf(TAG_SEQUENCE.getLocalPart().toString()) + ".", element);
                } else {
                    XMLUtils.reachElementEnd(this.reader);
                }
            }
            event = this.reader.nextEvent();
        }
    }

    private void readDistribution(Node node) throws XMLStreamException {
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().equals(TAG_DESCRIPTION)) {
                    this.storeHiddenData(node.getHiddenDataMap(), String.valueOf(TAG_DISTRIBUTION.getLocalPart().toString()) + ".", element);
                } else {
                    XMLUtils.reachElementEnd(this.reader);
                }
            }
            event = this.reader.nextEvent();
        }
    }

    private void readDate(Node node) throws XMLStreamException {
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().equals(TAG_DESCRIPTION) || element.getName().equals(TAG_VALUE) || element.getName().equals(TAG_MIN) || element.getName().equals(TAG_MAX)) {
                    this.storeHiddenData(node.getHiddenDataMap(), String.valueOf(TAG_DATE.getLocalPart().toString()) + ".", element);
                } else {
                    XMLUtils.reachElementEnd(this.reader);
                }
            }
            event = this.reader.nextEvent();
        }
    }

    private Node readSubtree(StartElement rootElement, Node parent) throws XMLStreamException {
        Node result = Node.newInstanceWithBranch();
        Branch b = result.getAfferentBranch();
        b.setLength(XMLUtils.readDoubleAttr(rootElement, ATTR_BRANCH_LENGTH, b.getLength()));
        XMLEvent event = this.reader.nextEvent();
        int confidenceCount = 0;
        boolean colorDefined = false;
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().equals(TAG_NAME)) {
                    this.storeHiddenData(result.getHiddenDataMap(), "", element);
                } else if (element.getName().equals(TAG_BRANCH_LENGTH)) {
                    b.setLength(Double.parseDouble(this.reader.nextEvent().asCharacters().getData()));
                    this.reader.nextEvent();
                } else if (element.getName().equals(TAG_CONFIDENCE)) {
                    TextLabel l = new TextLabel(result.getAfferentBranch().getLabels());
                    l.setID(XMLUtils.readStringAttr(element, ATTR_TYPE, "Confidence " + confidenceCount));
                    try {
                        l.getData().setDecimal(Double.parseDouble(this.reader.nextEvent().asCharacters().getData()));
                        result.getAfferentBranch().getLabels().add(l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ++confidenceCount;
                    this.reader.nextEvent();
                } else if (element.getName().equals(TAG_LINE_WIDTH)) {
                    double width = Double.parseDouble(this.reader.nextEvent().asCharacters().getData());
                    b.getHiddenDataMap().put("phyloXML.branch_width", new TextElementData(width));
                    b.getFormats().getLineWidth().setInMillimeters((float)width);
                    this.reader.nextEvent();
                } else if (element.getName().equals(TAG_LINE_COLOR)) {
                    Color color = this.readColor();
                    result.getFormats().setLineColor(color);
                    b.getFormats().setLineColor(color);
                    colorDefined = true;
                } else if (element.getName().equals(TAG_TAXONOMY)) {
                    this.readTaxonomy(result);
                } else if (element.getName().equals(TAG_SEQUENCE)) {
                    this.readSequence(element, result);
                } else if (element.getName().equals(TAG_DISTRIBUTION)) {
                    this.readDistribution(result);
                } else if (element.getName().equals(TAG_DATE)) {
                    this.readDate(result);
                } else if (element.getName().equals(TAG_CLADE)) {
                    Node subelement = this.readSubtree(element, result);
                    subelement.setParent(result);
                    result.getChildren().add(subelement);
                } else {
                    XMLUtils.reachElementEnd(this.reader);
                }
            }
            event = this.reader.nextEvent();
        }
        TextElementData data = result.getHiddenDataMap().get("phyloXML." + TAG_NAME.getLocalPart());
        if (data == null && (data = result.getHiddenDataMap().get("phyloXML." + TAG_TAXONOMY.getLocalPart() + "." + TAG_SCIENTIFIC_NAME.getLocalPart())) == null && (data = result.getHiddenDataMap().get("phyloXML." + TAG_TAXONOMY.getLocalPart() + "." + TAG_COMMON_NAME.getLocalPart())) == null) {
            data = result.getHiddenDataMap().get("phyloXML." + TAG_SEQUENCE.getLocalPart() + "." + TAG_NAME.getLocalPart());
        }
        if (data != null) {
            result.getData().assign(data);
        }
        if (parent != null && b.getHiddenDataMap().get("phyloXML.branch_width") == null) {
            data = parent.getAfferentBranch().getHiddenDataMap().get("phyloXML.branch_width");
            if (data != null) {
                b.getHiddenDataMap().put("phyloXML.branch_width", new TextElementData(data.getDecimal()));
                b.getFormats().getLineWidth().setInMillimeters((float)data.getDecimal());
            }
            if (!colorDefined) {
                Color parentColor = parent.getFormats().getLineColor();
                result.getFormats().setLineColor(parentColor);
                b.getFormats().setLineColor(parentColor);
            }
        }
        return result;
    }

    public Tree readNextTree(XMLEventReader reader, StartElement rootElement) throws XMLStreamException {
        this.reader = reader;
        Tree result = this.readPhylogeny(rootElement);
        this.names.clear();
        return result;
    }

    private Tree readPhylogeny(StartElement rootElement) throws XMLStreamException {
        this.names.add("Tree " + this.phylogenies.size());
        Tree result = new Tree();
        result.getFormats().setShowRooted(XMLUtils.readBooleanAttr(rootElement, ATTR_ROOTED, true));
        result.getScaleBar().getData().setText(XMLUtils.readStringAttr(rootElement, ATTR_BRANCH_LENGTH_UNIT, ""));
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().equals(TAG_NAME)) {
                    this.names.set(this.names.size() - 1, this.reader.nextEvent().asCharacters().getData());
                    this.reader.nextEvent();
                } else if (element.getName().equals(TAG_CLADE)) {
                    result.setPaintStart(this.readSubtree(element, null));
                    result.assignUniqueNames();
                    result.updateElementSet();
                    this.reader.nextEvent();
                } else {
                    XMLUtils.reachElementEnd(this.reader);
                }
            }
            event = this.reader.nextEvent();
        }
        return result;
    }

    private void readDocument(StartElement rootElement) throws XMLStreamException {
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().equals(TAG_PHYLOGENY)) {
                    this.phylogenies.add(this.readPhylogeny(element));
                    this.branchLengthsScaler.setDefaultAverageScale(this.phylogenies.lastElement());
                } else {
                    XMLUtils.reachElementEnd(this.reader);
                }
            }
            event = this.reader.nextEvent();
        }
    }

    @Override
    public Document readDocument(BufferedInputStream stream) throws Exception {
        this.reader = XMLInputFactory.newInstance().createXMLEventReader(stream);
        try {
            while (this.reader.hasNext()) {
                XMLEvent event = this.reader.nextEvent();
                switch (event.getEventType()) {
                    case 7: {
                        this.document = this.createEmptyDocument();
                        break;
                    }
                    case 8: {
                        this.reader.close();
                        Tree tree = this.phylogenies.get(this.parameterMap.getTreeSelector().select(this.names.toArray(new String[this.names.size()]), this.phylogenies));
                        AutoPositionLabelsEdit.position(tree.getPaintStart());
                        this.document.setTree(tree);
                        this.phylogenies.clear();
                        Document document = this.document;
                        return document;
                    }
                    case 1: {
                        StartElement element = event.asStartElement();
                        if (element.getName().equals(TAG_ROOT)) {
                            this.readDocument(element);
                            break;
                        }
                        XMLUtils.reachElementEnd(this.reader);
                    }
                }
            }
        }
        finally {
            this.reader.close();
            stream.close();
        }
        this.phylogenies.clear();
        return null;
    }

    @Override
    public DocumentIterator createIterator(BufferedInputStream stream) throws Exception {
        return null;
    }
}

