/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.nexus;

import info.bioinfweb.treegraph.document.AbstractPaintableElement;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.nodebranchdata.AbstractNodeBranchDataAdapter;
import java.util.Map;

class TranslTableAdapter
extends AbstractNodeBranchDataAdapter {
    private Map<String, Integer> nameToKeyMap = null;

    public TranslTableAdapter(Map<String, Integer> nameToKeyMap) {
        this.nameToKeyMap = nameToKeyMap;
    }

    @Override
    public String getName() {
        return "info.bioinfweb.treegraph.translation Table";
    }

    @Override
    public boolean readOnly() {
        return true;
    }

    @Override
    public boolean decimalOnly() {
        return false;
    }

    @Override
    public boolean isNewColumn() {
        return false;
    }

    @Override
    public boolean isDecimal(Node node) {
        return false;
    }

    @Override
    public boolean isString(Node node) {
        return true;
    }

    @Override
    public boolean isEmpty(Node node) {
        return false;
    }

    @Override
    public String getText(Node node) throws InternalError {
        String uniqueName = node.getUniqueName();
        if (this.nameToKeyMap.containsKey(uniqueName)) {
            return "" + this.nameToKeyMap.get(uniqueName);
        }
        throw new InternalError("The node name " + node.getUniqueName() + " could not be found as a key.");
    }

    @Override
    public void setText(Node node, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDecimal(Node node) {
        return Double.NaN;
    }

    @Override
    public void setDecimal(Node node, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextElementData toTextElementData(Node node) {
        return new TextElementData(this.getText(node));
    }

    @Override
    public void delete(Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractPaintableElement getDataElement(Node node) {
        return node;
    }
}

