/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.nexus;

import info.bioinfweb.commons.SystemUtils;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.NodeType;
import info.bioinfweb.treegraph.document.io.AbstractDocumentWriter;
import info.bioinfweb.treegraph.document.io.ReadWriteParameterMap;
import info.bioinfweb.treegraph.document.io.newick.NewickStringWriter;
import info.bioinfweb.treegraph.document.io.nexus.TranslTableAdapter;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.TreeMap;

public class NexusWriter
extends AbstractDocumentWriter {
    private String indention = "";

    @Override
    public void write(Document document, OutputStream stream, ReadWriteParameterMap properties) throws Exception {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));){
            writer.write(String.valueOf("#nexus".toUpperCase()) + SystemUtils.LINE_SEPARATOR);
            Node[] leavesInCurrentTree = (Node[])TreeSerializer.getElementsInSubtree((Node)document.getTree().getPaintStart(), (NodeType)NodeType.LEAVES, Node.class);
            if (properties.getBoolean("exportTaxaBlock", true)) {
                this.writeCommand(writer, "begin taxa");
                this.increaseIndention();
                this.writeCommand(writer, "dimensions ntax=" + leavesInCurrentTree.length);
                this.writeLine(writer, "taxlabels ");
                this.increaseIndention();
                int i = 0;
                while (i < leavesInCurrentTree.length) {
                    this.writeLine(writer, NewickStringWriter.formatName(leavesInCurrentTree[i], properties.getNodeBranchDataAdapter("leafNodeNamesAdapter", document.getDefaultLeafAdapter()), properties.getBoolean("spacesAsUnderscore", false)));
                    ++i;
                }
                this.writeLine(writer, ";");
                this.decreaseIndention();
                this.decreaseIndention();
                this.writeCommand(writer, "end");
            }
            this.writeCommand(writer, "begin trees");
            this.increaseIndention();
            if (properties.getBoolean("useTranslTable", true)) {
                this.writeLine(writer, "translate ");
                this.increaseIndention();
                TreeMap<String, Integer> nameToKeyMap = new TreeMap<String, Integer>();
                int i = 0;
                while (i < leavesInCurrentTree.length) {
                    nameToKeyMap.put(leavesInCurrentTree[i].getUniqueName(), i + 1);
                    String line = String.valueOf(i + 1) + " " + NewickStringWriter.formatName(leavesInCurrentTree[i], properties.getNodeBranchDataAdapter("leafNodeNamesAdapter", document.getDefaultLeafAdapter()), properties.getBoolean("spacesAsUnderscore", false));
                    if (i < leavesInCurrentTree.length - 1) {
                        line = String.valueOf(line) + ",";
                    }
                    this.writeLine(writer, line);
                    ++i;
                }
                this.writeLine(writer, ";");
                this.decreaseIndention();
                TranslTableAdapter translTableAdapter = new TranslTableAdapter(nameToKeyMap);
                ReadWriteParameterMap translationProperties = properties;
                translationProperties.put("leafNodeNamesAdapter", translTableAdapter);
                this.writeLine(writer, "tree tree1 = " + NewickStringWriter.write(document.getTree(), translationProperties));
            } else {
                this.writeLine(writer, "tree tree1 = " + NewickStringWriter.write(document.getTree(), properties));
            }
            this.decreaseIndention();
            this.writeCommand(writer, "end");
        }
    }

    private void writeCommand(Writer writer, String content) throws IOException {
        writer.write(String.valueOf(this.indention) + content + ';' + SystemUtils.LINE_SEPARATOR);
    }

    private void writeLine(Writer writer, String content) throws IOException {
        writer.write(String.valueOf(this.indention) + content + SystemUtils.LINE_SEPARATOR);
    }

    private void increaseIndention() {
        this.indention = String.valueOf(this.indention) + "\t";
    }

    private void decreaseIndention() {
        if (this.indention.length() > 0) {
            this.indention = this.indention.substring(1);
        }
    }
}

