/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.nexus;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.io.DocumentIterator;
import info.bioinfweb.treegraph.document.io.TextStreamReader;
import info.bioinfweb.treegraph.document.io.newick.NewickReader;
import info.bioinfweb.treegraph.document.io.newick.NewickTreeList;
import info.bioinfweb.treegraph.document.io.nexus.NexusDocument;
import info.bioinfweb.treegraph.document.io.nexus.NexusParser;
import info.bioinfweb.treegraph.document.nodebranchdata.BranchLengthAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeNameAdapter;
import java.io.BufferedInputStream;

public class NexusReader
extends TextStreamReader {
    @Override
    public Document readDocument(BufferedInputStream stream) throws Exception {
        NexusDocument nex = NexusParser.parse(NexusReader.readStream(stream));
        NewickTreeList trees = nex.createTrees(this.parameterMap.getNodeBranchDataAdapter("internalNodeNamesAdapter", NodeNameAdapter.getSharedInstance()), this.parameterMap.getNodeBranchDataAdapter("branchLengthAdapter", BranchLengthAdapter.getSharedInstance()), this.parameterMap.getBoolean("translateInternalNodeNames", true));
        int treePos = this.parameterMap.getTreeSelector().select(nex.namesToArray(), trees.treesAsList());
        Document result = this.createEmptyDocument();
        result.setTree(trees.getTree(treePos));
        NodeBranchDataAdapter supportAdapter = this.parameterMap.getNodeBranchDataAdapter("internalNodeNamesAdapter", NodeNameAdapter.getSharedInstance());
        NewickReader.setDefaultSupportAdapter(result, supportAdapter, treePos, trees);
        if (trees.getHiddenDataAdded(treePos)) {
            NewickReader.displayHiddenDataMessage(this.parameterMap.getApplicationLogger(), 76);
        }
        return result;
    }

    @Override
    public DocumentIterator createIterator(BufferedInputStream stream) throws Exception {
        return null;
    }
}

