/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.nexus;

import info.bioinfweb.treegraph.document.io.nexus.NexusCommand;
import info.bioinfweb.treegraph.document.io.nexus.NexusDocument;
import info.bioinfweb.treegraph.document.io.nexus.NexusError;
import info.bioinfweb.treegraph.document.io.nexus.NexusException;
import info.bioinfweb.treegraph.document.io.nexus.TranslTable;
import java.io.IOException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NexusParser {
    public static final int MAX_EXPECTED_COMMAND_LENGTH = 524288;
    public static final String FIRST_LINE = "#nexus";
    public static final String BEGIN_COMMAND = "begin";
    public static final String END_COMMAND = "end";
    public static final char COMMAND_END = ';';
    public static final char COMMENT_START = '[';
    public static final char COMMENT_END = ']';
    public static final char KEY_VALUE_SEPERATOR = '=';
    public static final char WORD_DELIMITER = '\'';
    public static final char WHITESPACE = ' ';
    public static final String BLOCK_NAME_TAXA = "taxa";
    public static final String BLOCK_NAME_TREES = "trees";
    public static final String DIMENSIONS_NAME = "dimensions";
    public static final String TAXLABELS_NAME = "taxlabels";
    public static final String TRANSL_TABLE_NAME = "translate";
    public static final String TREE_NAME = "tree";
    public static final String DIMENSIONS_SUBCOMMAND_NTAX = "ntax";
    public static final String ROOTED_HOT_COMMENT = "&r";
    public static final String UNROOTED_HOT_COMMENT = "&u";
    public static final Pattern BLOCK_BEGIN_PATTERN = Pattern.compile("begin");
    public static final Pattern BLOCK_END_PATTERN = Pattern.compile("(end|endblock)");
    public static final Pattern COMMAND_PATTERN = Pattern.compile(";");
    public static final Pattern NAME_SEPARATOR_PATTERN = Pattern.compile("'");
    public static final Pattern ENTRY_PATTERN = Pattern.compile("\\s*(\\d*)\\s*(.*)\\s*");
    public static final Pattern ENCLOSED_NAME_PATTERN = Pattern.compile("\\s*(\\d*)\\s*'(.*)'\\s*");
    public static final Pattern TREES_PATTERN = Pattern.compile("\\s*trees\\s*");
    public static final Pattern TRANSL_TABLE_PATTERN = Pattern.compile("translate");
    public static final Pattern TRANSL_TABLE_SEPARATOR_PATTERN = Pattern.compile(",");
    public static final Pattern TREE_COMMAND_PATTERN = Pattern.compile("(tree|utree)");
    public static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    public static final Pattern EMPTY_PATTERN = Pattern.compile(".*", 32);

    private static NexusCommand[] scan(String content) {
        Vector<NexusCommand> result = new Vector<NexusCommand>();
        StringBuffer command = new StringBuffer(Math.max(524288, content.length()));
        int i = 0;
        while (i < content.length()) {
            switch (content.charAt(i)) {
                case '[': {
                    ++i;
                    command.append('[');
                    while (i < content.length() && content.charAt(i) != ']') {
                        command.append(content.charAt(i));
                        ++i;
                    }
                    command.append(']');
                    break;
                }
                case '\'': {
                    ++i;
                    command.append('\'');
                    while (i < content.length() && content.charAt(i) != '\'') {
                        command.append(content.charAt(i));
                        ++i;
                    }
                    command.append('\'');
                    break;
                }
                case ';': {
                    result.add(new NexusCommand(command.toString()));
                    command.delete(0, command.length());
                    break;
                }
                default: {
                    command.append(content.charAt(i));
                }
            }
            ++i;
        }
        return result.toArray(new NexusCommand[result.size()]);
    }

    public static int nextPosOutsideComment(String text, int start, char character) {
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '[') {
                while (++i < text.length() && text.charAt(i) != ']') {
                }
            } else if (text.charAt(i) == character) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String removeComments(String content) {
        StringBuffer result = new StringBuffer(content.length());
        int i = 0;
        while (i < content.length()) {
            if (content.charAt(i) == '[') {
                while (++i < content.length() && content.charAt(i) != ']') {
                }
            } else {
                result.append(content.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    private static int findCommand(NexusCommand[] commands, int start, int end, Pattern namePattern, Pattern tokenPattern) {
        int i = start;
        while (i < Math.min(commands.length, end)) {
            if (namePattern.matcher(commands[i].getName().toLowerCase()).matches() && tokenPattern.matcher(commands[i].getTokens().trim().toLowerCase()).matches()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int findBlockEnd(NexusCommand[] commands, int start, int end) {
        return NexusParser.findCommand(commands, start, end, BLOCK_END_PATTERN, EMPTY_PATTERN);
    }

    private static String parseName(String name) {
        if (name.contains(Character.toString('\''))) {
            String result = "";
            int i = 0;
            while (i < name.length()) {
                if (name.charAt(i) != '\'') {
                    result = String.valueOf(result) + name.charAt(i);
                }
                if (i + 1 < name.length() && name.charAt(i + 1) == '\'') {
                    result = String.valueOf(result) + '\'';
                }
                ++i;
            }
            return result;
        }
        return name.replaceAll(Character.toString('_'), " ");
    }

    private static void readTranslTable(NexusCommand command, TranslTable translTable) throws IOException {
        String[] entries = TRANSL_TABLE_SEPARATOR_PATTERN.split(NexusParser.removeComments(command.getTokens()));
        String resultKey = "";
        String resultName = "";
        int i = 0;
        while (i < entries.length) {
            Matcher entryPatternMatcher = ENTRY_PATTERN.matcher(entries[i]);
            Matcher enclosedPatternMatcher = ENCLOSED_NAME_PATTERN.matcher(entries[i]);
            if (entryPatternMatcher.matches() && !enclosedPatternMatcher.matches()) {
                resultKey = entryPatternMatcher.group(1);
                resultName = entryPatternMatcher.group(2);
            } else if (enclosedPatternMatcher.matches()) {
                resultKey = enclosedPatternMatcher.group(1);
                resultName = enclosedPatternMatcher.group(2);
            } else {
                throw new IOException("Line " + (i + 1) + " of the translation table contains invalid entries.");
            }
            if (resultKey.isEmpty()) {
                resultKey = String.valueOf(i + 1);
            }
            translTable.add(NexusParser.parseName(resultKey), NexusParser.parseName(resultName));
            ++i;
        }
    }

    private static boolean readTree(String tokens, NexusDocument document) {
        boolean result;
        int separatorPos = NexusParser.nextPosOutsideComment(tokens, 0, '=');
        boolean bl = result = separatorPos != -1;
        if (result) {
            document.add(tokens.substring(0, separatorPos).trim(), String.valueOf(tokens.substring(separatorPos + 1, tokens.length()).trim()) + ';');
        }
        return result;
    }

    public static NexusDocument parse(String content) throws NexusException, IOException {
        if ((content = content.trim()).toLowerCase().startsWith(FIRST_LINE)) {
            NexusCommand[] commands = NexusParser.scan(content.substring(FIRST_LINE.length()));
            int treesStart = NexusParser.findCommand(commands, 0, commands.length, BLOCK_BEGIN_PATTERN, TREES_PATTERN);
            if (treesStart != -1) {
                int treesEnd = NexusParser.findBlockEnd(commands, treesStart + 1, commands.length);
                if (treesEnd != -1) {
                    NexusDocument result = new NexusDocument();
                    int translPos = NexusParser.findCommand(commands, treesStart, treesEnd, TRANSL_TABLE_PATTERN, EMPTY_PATTERN);
                    if (translPos != -1) {
                        NexusParser.readTranslTable(commands[translPos], result.getTranslTable());
                    }
                    int treePos = NexusParser.findCommand(commands, treesStart, treesEnd, TREE_COMMAND_PATTERN, EMPTY_PATTERN);
                    while (treePos != -1) {
                        NexusParser.readTree(commands[treePos].getTokens(), result);
                        treePos = NexusParser.findCommand(commands, treePos + 1, treesEnd, TREE_COMMAND_PATTERN, EMPTY_PATTERN);
                    }
                    return result;
                }
                throw new NexusException(NexusError.TREES_UNTERMINATED);
            }
            throw new NexusException(NexusError.NO_TREES);
        }
        throw new NexusException(NexusError.NO_NEXUS);
    }
}

