/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.nexus;

import info.bioinfweb.treegraph.document.io.AbstractFilter;
import info.bioinfweb.treegraph.document.io.ReadWriteFormat;
import info.bioinfweb.treegraph.document.io.TreeFilter;
import java.io.File;
import java.io.FileReader;

public class NexusFilter
extends AbstractFilter
implements TreeFilter {
    public static final String[] EXTENSIONS = new String[]{".tre", ".tree", ".trees", ".con", ".nex", ".nexus"};

    @Override
    public ReadWriteFormat getFormat() {
        return ReadWriteFormat.NEXUS;
    }

    @Override
    public boolean validExtension(String name) {
        name = name.toLowerCase();
        int i = 0;
        while (i < EXTENSIONS.length) {
            if (name.endsWith(EXTENSIONS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean accept(File f) {
        boolean result;
        block9: {
            result = super.accept(f);
            if (result && f.isFile()) {
                try (FileReader reader = new FileReader(f);){
                    char[] firstChars = new char["#nexus".length()];
                    int charsRead = reader.read(firstChars, 0, "#nexus".length());
                    if (charsRead == "#nexus".length()) {
                        int i = 0;
                        while (i < firstChars.length) {
                            if (Character.toLowerCase(firstChars[i]) != Character.toLowerCase("#nexus".charAt(i))) {
                                result = false;
                                break block9;
                            }
                            ++i;
                        }
                        break block9;
                    }
                    result = false;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return result;
    }

    @Override
    public String getDescription() {
        return "Nexus files (*.tre*; *.con; *.nex*)";
    }

    @Override
    public String getDefaultExtension() {
        return ".tre";
    }
}

