/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.nexus;

import info.bioinfweb.treegraph.document.io.newick.NewickStringReader;
import info.bioinfweb.treegraph.document.io.newick.NewickTreeList;
import info.bioinfweb.treegraph.document.io.nexus.TranslTable;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import java.util.List;
import java.util.Vector;

public class NexusDocument {
    private TranslTable translTable = new TranslTable();
    private List<String> names = new Vector<String>();
    private List<String> trees = new Vector<String>();

    public TranslTable getTranslTable() {
        return this.translTable;
    }

    public boolean add(String name, String tree) {
        this.names.add(name);
        return this.trees.add(tree);
    }

    public String getName(int pos) {
        return this.names.get(pos);
    }

    public String getTree(int pos) {
        return this.trees.get(pos);
    }

    public String[] namesToArray() {
        return this.names.toArray(new String[this.names.size()]);
    }

    public String[] treesToArray() {
        return this.trees.toArray(new String[this.trees.size()]);
    }

    public int size() {
        return this.names.size();
    }

    public NewickTreeList createTrees(NodeBranchDataAdapter internalAdapter, NodeBranchDataAdapter branchLengthsAdapter, boolean translateInternals) {
        return NewickStringReader.read(this.treesToArray(), internalAdapter, branchLengthsAdapter, this.getTranslTable(), translateInternals);
    }
}

