/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.nexus;

import info.bioinfweb.treegraph.document.io.nexus.NexusParser;
import java.util.regex.Pattern;

public class NexusCommand {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private String name = "";
    private String tokens = "";

    public NexusCommand(String content) {
        content = content.trim();
        int splitPos = 0;
        while (splitPos < content.length() && !WHITESPACE_PATTERN.matcher(content.substring(splitPos)).lookingAt()) {
            if (content.charAt(splitPos) == '[') {
                while (++splitPos < content.length() && content.charAt(splitPos) != ']') {
                }
                ++splitPos;
                while (splitPos < content.length() && WHITESPACE_PATTERN.matcher(content.substring(splitPos)).lookingAt()) {
                    ++splitPos;
                }
                continue;
            }
            ++splitPos;
        }
        this.name = NexusParser.removeComments(content.substring(0, splitPos)).trim();
        if (splitPos + 1 < content.length()) {
            this.tokens = content.substring(splitPos + 1, content.length());
        }
    }

    public NexusCommand(String name, String tokens) {
        this.name = name;
        this.tokens = tokens;
    }

    public String getName() {
        return this.name;
    }

    public String getTokens() {
        return this.tokens;
    }
}

