/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.newick;

import info.bioinfweb.treegraph.document.Tree;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class NewickTreeList {
    private Tree[] trees;
    private boolean[] hiddenDataAdded;
    private boolean[] internalNamesAdded;

    public NewickTreeList(Tree[] trees, boolean[] hiddenDataAdded, boolean[] internalNamesAdded) {
        if (trees.length != hiddenDataAdded.length) {
            throw new IllegalArgumentException("The two specified fields contain a different number of elements (" + trees.length + ", " + hiddenDataAdded.length + ")");
        }
        this.trees = trees;
        this.hiddenDataAdded = hiddenDataAdded;
        this.internalNamesAdded = internalNamesAdded;
    }

    public Tree getTree(int index) {
        return this.trees[index];
    }

    public List<Tree> treesAsList() {
        return Collections.unmodifiableList(Arrays.asList(this.trees));
    }

    public boolean getHiddenDataAdded(int index) {
        return this.hiddenDataAdded[index];
    }

    public int size() {
        return this.trees.length;
    }

    public boolean getInternalNamesAdded(int index) {
        return this.internalNamesAdded[index];
    }
}

