/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.newick;

import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.io.ReadWriteParameterMap;
import info.bioinfweb.treegraph.document.io.newick.NewickStringChars;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeNameAdapter;

public class NewickStringWriter
extends NewickStringChars {
    private static boolean isFreeName(String name, boolean edited) {
        if (name.length() == 0) {
            return true;
        }
        if (!edited && name.contains("_")) {
            return false;
        }
        if (NewickStringWriter.isFreeNameFirstChar(name.charAt(0))) {
            int i = 1;
            while (i < name.length()) {
                if (!NewickStringWriter.isFreeNameChar(name.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static String formatName(Node node, NodeBranchDataAdapter adapter, boolean spacesAsUnderscore) {
        String name = "";
        if (adapter.isDecimal(node)) {
            name = "" + adapter.getDecimal(node);
        } else if (adapter.isString(node)) {
            name = adapter.getText(node);
        }
        if (NewickStringWriter.isFreeName(name, false)) {
            return name;
        }
        String editedName = name.replaceAll(" ", "_");
        if (spacesAsUnderscore && NewickStringWriter.isFreeName(editedName, true)) {
            return editedName;
        }
        StringBuffer result = new StringBuffer(name.length() * 2);
        result.append('\'');
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == '\'') {
                result.append('\'');
            }
            result.append(name.charAt(i));
            ++i;
        }
        result.append('\'');
        return result.toString();
    }

    private static String writeSubtree(Node root, NodeBranchDataAdapter internalAdapter, NodeBranchDataAdapter leafAdapter, NodeBranchDataAdapter branchLengthAdapter, boolean spacesAsUnderscore) {
        String result = "";
        if (!root.isLeaf()) {
            result = String.valueOf(result) + '(';
            int size = root.getChildren().size();
            int i = 0;
            while (i < size - 1) {
                result = String.valueOf(result) + NewickStringWriter.writeSubtree(root.getChildren().get(i), internalAdapter, leafAdapter, branchLengthAdapter, spacesAsUnderscore);
                result = String.valueOf(result) + ',';
                ++i;
            }
            result = String.valueOf(result) + NewickStringWriter.writeSubtree(root.getChildren().get(size - 1), internalAdapter, leafAdapter, branchLengthAdapter, spacesAsUnderscore);
            result = String.valueOf(result) + ')';
        }
        result = root.isLeaf() ? String.valueOf(result) + NewickStringWriter.formatName(root, leafAdapter, spacesAsUnderscore) : String.valueOf(result) + NewickStringWriter.formatName(root, internalAdapter, spacesAsUnderscore);
        if (branchLengthAdapter != null && branchLengthAdapter.isDecimal(root)) {
            result = String.valueOf(result) + ":" + branchLengthAdapter.getDecimal(root);
        }
        return result;
    }

    public static String write(Tree tree, ReadWriteParameterMap properties) {
        return NewickStringWriter.write(tree, properties.getNodeBranchDataAdapter("internalNodeNamesAdapter", NodeNameAdapter.getSharedInstance()), properties.getNodeBranchDataAdapter("leafNodeNamesAdapter", NodeNameAdapter.getSharedInstance()), properties.getNodeBranchDataAdapter("branchLengthAdapter", null), properties.getBoolean("spacesAsUnderscore", false));
    }

    public static String write(Tree tree, NodeBranchDataAdapter internalAdapter, NodeBranchDataAdapter leafAdapter, NodeBranchDataAdapter branchLengthAdapter, boolean spacesAsUnderscore) {
        String result = tree.getFormats().getShowRooted() ? "[&r]" : "[&u]";
        result = tree.isEmpty() ? String.valueOf(result) + ';' : String.valueOf(result) + NewickStringWriter.writeSubtree(tree.getPaintStart(), internalAdapter, leafAdapter, branchLengthAdapter, spacesAsUnderscore) + ';';
        return result;
    }
}

