/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.newick;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.io.newick.BranchLengthsScaler;
import info.bioinfweb.treegraph.document.io.newick.CommentDataReader;
import info.bioinfweb.treegraph.document.io.newick.NewickException;
import info.bioinfweb.treegraph.document.io.newick.NewickScanner;
import info.bioinfweb.treegraph.document.io.newick.NewickStringChars;
import info.bioinfweb.treegraph.document.io.newick.NewickToken;
import info.bioinfweb.treegraph.document.io.newick.NewickTreeList;
import info.bioinfweb.treegraph.document.io.newick.TokenType;
import info.bioinfweb.treegraph.document.io.nexus.TranslTable;
import info.bioinfweb.treegraph.document.nodebranchdata.BranchLengthAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeNameAdapter;
import java.util.List;

public class NewickStringReader
extends NewickStringChars {
    public static final NodeNameAdapter LEAF_ADAPTER = NodeNameAdapter.getSharedInstance();
    public static final BranchLengthAdapter BRANCH_LENGTH_ADAPTER = BranchLengthAdapter.getSharedInstance();
    private String newickDescription;
    private List<NewickToken> tokens;
    private NodeBranchDataAdapter internalAdapter;
    private NodeBranchDataAdapter branchLengthsAdapter;
    private TranslTable translTable;
    private boolean translateInternals;
    private boolean hiddenDataAdded = false;
    private boolean internalNamesAdded = false;
    private CommentDataReader commentDataReader = new CommentDataReader();
    private BranchLengthsScaler branchLengthsScaler = new BranchLengthsScaler();

    private int searchSubtreeEnd(int start, int end) {
        int pos = start;
        while (pos <= end) {
            TokenType type = this.tokens.get(pos).getType();
            if (type.equals((Object)TokenType.SUBTREE_END)) {
                return pos;
            }
            if (type.equals((Object)TokenType.SUBTREE_START) && (pos = this.searchSubtreeEnd(pos + 1, end)) == -1) {
                return -1;
            }
            ++pos;
        }
        return -1;
    }

    private int searchToken(int start, int end, TokenType type) {
        int pos = start;
        while (pos <= end) {
            if (this.tokens.get(pos).getType().equals((Object)type)) {
                return pos;
            }
            if (this.tokens.get(pos).getType().equals((Object)TokenType.SUBTREE_START) && (pos = this.searchSubtreeEnd(pos + 1, end)) == -1) {
                return -1;
            }
            ++pos;
        }
        return -1;
    }

    private void readHotComment(String comment, Node node, boolean isOnNode) {
        try {
            this.commentDataReader.read(comment, node, isOnNode);
            this.hiddenDataAdded = this.hiddenDataAdded || !node.getAfferentBranch().getHiddenDataMap().isEmpty() || !node.getHiddenDataMap().isEmpty();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Node readBranch(int start, int end, Node root) throws NewickException {
        if (this.tokens.get(end).getType().equals((Object)TokenType.LENGTH)) {
            Node result = this.readSubtree(start, end - 1);
            this.branchLengthsAdapter.setDecimal(result, this.tokens.get(end).getLength());
            this.readHotComment(this.tokens.get(end).getComment(), result, false);
            return result;
        }
        return this.readSubtree(start, end);
    }

    private void readBranchList(int start, int end, Node root) throws NewickException {
        int branchEnd = this.searchToken(start, end, TokenType.ELEMENT_SEPARATOR);
        branchEnd = branchEnd == -1 ? end : --branchEnd;
        Node child = this.readBranch(start, branchEnd, root);
        child.setParent(root);
        root.getChildren().add(child);
        if (branchEnd < end) {
            this.readBranchList(branchEnd + 2, end, root);
        }
    }

    private void readName(int previousEnd, int end, Node root, NodeBranchDataAdapter adapter, TranslTable translTable) throws NewickException {
        this.readHotComment(this.tokens.get(end).getComment(), root, true);
        if (previousEnd == end - 1) {
            if (this.tokens.get(end).getType().equals((Object)TokenType.NAME)) {
                String text = this.tokens.get(end).getText();
                if (translTable != null && !this.tokens.get(end).wasDelimited()) {
                    int pos;
                    String newText = translTable.get(text);
                    if (newText != null) {
                        text = newText;
                    } else if (Math2.isInt(text) && Math2.isBetween(pos = Integer.parseInt(text), 0, translTable.size() - 1)) {
                        text = translTable.get(pos);
                    }
                }
                try {
                    adapter.setDecimal(root, Double.parseDouble(text));
                    this.internalNamesAdded = true;
                }
                catch (NumberFormatException e) {
                    adapter.setText(root, text);
                    this.internalNamesAdded = true;
                }
            }
        } else if (previousEnd != end) {
            throw new NewickException(this.tokens.get(previousEnd + 2), this.newickDescription);
        }
    }

    private Node readInternal(int start, int end) throws NewickException {
        if (this.tokens.get(start).getType().equals((Object)TokenType.SUBTREE_START)) {
            int subtreeEnd = this.searchToken(start + 1, end, TokenType.SUBTREE_END);
            Node root = Node.newInstanceWithBranch();
            this.readBranchList(start + 1, subtreeEnd - 1, root);
            if (this.translateInternals) {
                this.readName(subtreeEnd, end, root, this.internalAdapter, this.translTable);
            } else {
                this.readName(subtreeEnd, end, root, this.internalAdapter, null);
            }
            return root;
        }
        throw new NewickException(this.tokens.get(start).getTextPos(), this.newickDescription, TokenType.SUBTREE_START, this.tokens.get(start).getType());
    }

    private Node readLeaf(int start, int end) throws NewickException {
        Node result = Node.newInstanceWithBranch();
        this.readName(start - 1, end, result, LEAF_ADAPTER, this.translTable);
        return result;
    }

    private Node readSubtree(int start, int end) throws NewickException {
        if (this.tokens.get(start).getType().equals((Object)TokenType.SUBTREE_START)) {
            return this.readInternal(start, end);
        }
        return this.readLeaf(start, end);
    }

    private Tree readTree() throws NewickException {
        Tree result = new Tree();
        if (this.tokens.size() == 0) {
            throw new NewickException(0, this.newickDescription, "String length is 0.");
        }
        if (this.tokens.get(0).equals((Object)TokenType.TERMNINAL_SYMBOL)) {
            return result;
        }
        if (this.tokens.size() < 3) {
            throw new NewickException(0, this.newickDescription, "Incomplete Newick string");
        }
        if (!(this.tokens.get(0).getType().equals((Object)TokenType.SUBTREE_START) || this.tokens.get(0).getType().equals((Object)TokenType.UNROOTED_COMMAND) && this.tokens.get(1).getType().equals((Object)TokenType.SUBTREE_START) || this.tokens.get(0).getType().equals((Object)TokenType.ROOTED_COMMAND) && this.tokens.get(1).getType().equals((Object)TokenType.SUBTREE_START))) {
            if (this.tokens.get(0).getType().equals((Object)TokenType.UNROOTED_COMMAND)) {
                throw new NewickException(this.tokens.get(1).getTextPos(), this.newickDescription, TokenType.SUBTREE_START, this.tokens.get(1).getType());
            }
            throw new NewickException(0, this.newickDescription, TokenType.SUBTREE_START, this.tokens.get(0).getType());
        }
        int start = 0;
        if (this.tokens.get(0).getType().equals((Object)TokenType.ROOTED_COMMAND)) {
            result.getFormats().setShowRooted(true);
            start = 1;
        } else if (this.tokens.get(0).getType().equals((Object)TokenType.UNROOTED_COMMAND)) {
            result.getFormats().setShowRooted(false);
            start = 1;
        }
        int end = this.searchToken(start + 1, this.tokens.size() - 1, TokenType.SUBTREE_END);
        if (end == -1) {
            throw new NewickException(0, this.newickDescription, "Unterminated subtree");
        }
        if (this.tokens.size() >= end + 2 && this.tokens.get(this.tokens.size() - 1).getType().equals((Object)TokenType.TERMNINAL_SYMBOL)) {
            result.setPaintStart(this.readSubtree(start, this.tokens.size() - 2));
            result.assignUniqueNames();
            result.updateElementSet();
            return result;
        }
        throw new NewickException(0, this.newickDescription, "Tree not completed by \";\"");
    }

    public boolean getHiddenDataAdded() {
        return this.hiddenDataAdded;
    }

    private boolean getInternalNamesAdded() {
        return this.internalNamesAdded;
    }

    protected Tree read(String newick) throws NewickException {
        return this.read(newick, LEAF_ADAPTER, BRANCH_LENGTH_ADAPTER, null, false);
    }

    protected Tree read(String newick, NodeBranchDataAdapter internalAdapter, NodeBranchDataAdapter branchLengthsAdapter) throws NewickException {
        return this.read(newick, internalAdapter, branchLengthsAdapter, null, false);
    }

    protected Tree read(String newick, NodeBranchDataAdapter internalAdapter, NodeBranchDataAdapter branchLengthsAdapter, TranslTable translTable, boolean translateInternals) throws NewickException {
        this.newickDescription = newick;
        this.tokens = NewickScanner.parse(newick);
        this.internalAdapter = internalAdapter;
        this.branchLengthsAdapter = branchLengthsAdapter;
        this.translTable = translTable;
        this.translateInternals = translateInternals;
        this.hiddenDataAdded = false;
        this.internalNamesAdded = false;
        Tree tree = this.readTree();
        this.branchLengthsScaler.setDefaultAverageScale(tree);
        return tree;
    }

    public static NewickTreeList read(String[] newick, NodeBranchDataAdapter internalAdapter, NodeBranchDataAdapter branchLengthsAdapter, TranslTable translTable, boolean translateInternals) throws NewickException {
        Tree[] trees = new Tree[newick.length];
        boolean[] hiddenDataAdded = new boolean[newick.length];
        boolean[] internalNamesAdded = new boolean[newick.length];
        NewickStringReader reader = new NewickStringReader();
        int i = 0;
        while (i < newick.length) {
            trees[i] = reader.read(newick[i], internalAdapter, branchLengthsAdapter, translTable, translateInternals);
            hiddenDataAdded[i] = reader.getHiddenDataAdded();
            internalNamesAdded[i] = reader.getInternalNamesAdded();
            ++i;
        }
        return new NewickTreeList(trees, hiddenDataAdded, internalNamesAdded);
    }
}

