/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.newick;

import info.bioinfweb.treegraph.document.io.newick.NewickException;
import info.bioinfweb.treegraph.document.io.newick.NewickStringChars;
import info.bioinfweb.treegraph.document.io.newick.NewickToken;
import info.bioinfweb.treegraph.document.io.newick.TokenType;
import java.util.List;
import java.util.Vector;

public class NewickScanner
extends NewickStringChars {
    private static NewickToken readFreeName(String text, int start) {
        String result = "" + text.charAt(start);
        int pos = start + 1;
        while (pos < text.length() && NewickScanner.isFreeNameChar(text.charAt(pos))) {
            result = text.charAt(pos) == '_' ? String.valueOf(result) + ' ' : String.valueOf(result) + text.charAt(pos);
            ++pos;
        }
        if (pos == text.length()) {
            throw NewickException.getUnterminatedNameException(start, text);
        }
        return new NewickToken(start, result, false);
    }

    private static int readDelimitedName(String text, int start, NewickToken token) {
        int pos = ++start;
        String result = "";
        while (true) {
            if (pos < text.length() && text.charAt(pos) != '\'') {
                result = String.valueOf(result) + text.charAt(pos);
                ++pos;
                continue;
            }
            if (pos + 1 < text.length() && text.charAt(pos + 1) == '\'') {
                result = String.valueOf(result) + '\'';
                pos += 2;
            }
            if (pos >= text.length() || text.charAt(pos) == '\'') break;
        }
        if (pos == text.length()) {
            throw NewickException.getUnterminatedNameException(start, text);
        }
        token.setText(result);
        token.setDelimited(true);
        return pos;
    }

    private static int readBranchLength(String text, int start, NewickToken token) {
        double value;
        int end = start;
        while (end < text.length() && !NewickScanner.isCharAfterLength(text.charAt(end))) {
            ++end;
        }
        try {
            value = Double.parseDouble(text.substring(start, end));
        }
        catch (NumberFormatException e) {
            throw new NewickException(start, text, "Illegal length statement");
        }
        token.setLength(value);
        return end - 1;
    }

    private static int readComment(String text, int start, List<NewickToken> tokenList) {
        int pos = ++start;
        String result = "";
        while (pos < text.length() && text.charAt(pos) != ']') {
            result = String.valueOf(result) + text.charAt(pos);
            ++pos;
        }
        if (pos == text.length()) {
            throw NewickException.getUnterminatedCommentException(start, text);
        }
        if (result.toLowerCase().equals("&u")) {
            tokenList.add(new NewickToken(TokenType.UNROOTED_COMMAND, start));
        } else if (result.toLowerCase().equals("&r")) {
            tokenList.add(new NewickToken(TokenType.ROOTED_COMMAND, start));
        } else {
            tokenList.get(tokenList.size() - 1).setComment(result);
        }
        return pos;
    }

    public static List<NewickToken> parse(String text) {
        Vector<NewickToken> result = new Vector<NewickToken>();
        int pos = 0;
        while (pos < text.length() && text.charAt(pos) != ';') {
            switch (text.charAt(pos)) {
                case '(': {
                    result.add(new NewickToken(TokenType.SUBTREE_START, pos));
                    break;
                }
                case ')': {
                    result.add(new NewickToken(TokenType.SUBTREE_END, pos));
                    break;
                }
                case ',': {
                    result.add(new NewickToken(TokenType.ELEMENT_SEPARATOR, pos));
                    break;
                }
                case ':': {
                    NewickToken token = new NewickToken(TokenType.LENGTH, pos);
                    if (text.charAt(++pos) == '[') {
                        pos = NewickScanner.readComment(text, pos, result) + 1;
                    }
                    pos = NewickScanner.readBranchLength(text, pos, token);
                    result.add(token);
                    break;
                }
                case '\'': {
                    NewickToken token = new NewickToken(TokenType.NAME, pos);
                    pos = NewickScanner.readDelimitedName(text, pos, token);
                    result.add(token);
                    break;
                }
                case '[': {
                    pos = NewickScanner.readComment(text, pos, result);
                    break;
                }
                default: {
                    if (!NewickScanner.isFreeNameFirstChar(text.charAt(pos))) break;
                    NewickToken token = NewickScanner.readFreeName(text, pos);
                    pos += token.getText().length() - 1;
                    result.add(token);
                }
            }
            ++pos;
        }
        if (pos < text.length() && text.charAt(pos) == ';') {
            result.add(new NewickToken(TokenType.TERMNINAL_SYMBOL, pos));
        }
        return result;
    }
}

