/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.newick;

import info.bioinfweb.commons.log.ApplicationLogger;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.io.AbstractDocumentIterator;
import info.bioinfweb.treegraph.document.io.DocumentIterator;
import info.bioinfweb.treegraph.document.io.DocumentReader;
import info.bioinfweb.treegraph.document.io.TextStreamReader;
import info.bioinfweb.treegraph.document.io.newick.NewickStringReader;
import info.bioinfweb.treegraph.document.io.newick.NewickTreeList;
import info.bioinfweb.treegraph.document.nodebranchdata.BranchLengthAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NewNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeNameAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.VoidNodeBranchDataAdapter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;

public class NewickReader
extends TextStreamReader
implements DocumentReader {
    private String terminateNewick(String newick) {
        if (!newick.endsWith(";")) {
            newick = String.valueOf(newick) + ';';
        }
        return newick;
    }

    private String readNextTree(InputStreamReader reader) throws IOException {
        int code = reader.read();
        if (code == -1) {
            return null;
        }
        StringBuffer result = new StringBuffer(524288);
        Status status = Status.FREE;
        while (code != -1) {
            char c = (char)code;
            result.append(c);
            block0 : switch (status) {
                case FREE: {
                    switch (result.charAt(result.length() - 1)) {
                        case '\'': {
                            status = Status.NAME;
                            break block0;
                        }
                        case '[': {
                            status = Status.COMMENT;
                            break block0;
                        }
                        case ';': {
                            return result.toString();
                        }
                    }
                    break;
                }
                case NAME: {
                    if (c != '\'') break;
                    status = Status.FREE;
                    break;
                }
                case COMMENT: {
                    if (c != ']') break;
                    status = Status.FREE;
                }
            }
            code = reader.read();
        }
        String newick = result.toString().trim();
        if (newick.equals("")) {
            return null;
        }
        return this.terminateNewick(newick);
    }

    private String[] splitDocument(InputStreamReader reader) throws IOException {
        LinkedList<String> result = new LinkedList<String>();
        String tree = this.readNextTree(reader);
        while (tree != null) {
            result.add(tree);
            tree = this.readNextTree(reader);
        }
        return result.toArray(new String[result.size()]);
    }

    public static void displayHiddenDataMessage(ApplicationLogger logger, int helpCode) {
        logger.addMessage("The imported Newick string contained comments inside the tree definitions which have been imported as hidden branch data column(s). (See table right of the tree.) You can select \"Edit\" -> \"Node/branch data\" -> \"Copy column...\" from the main menu if you want to store the imported data in another type of node/branch data column instead.", helpCode);
    }

    public static void setDefaultSupportAdapter(Document document, NodeBranchDataAdapter supportAdapter, int treePos, NewickTreeList trees) {
        if (!(supportAdapter instanceof NodeNameAdapter) && trees.getInternalNamesAdded(treePos)) {
            if (supportAdapter instanceof NewNodeBranchDataAdapter) {
                document.setDefaultSupportAdapter(((NewNodeBranchDataAdapter)supportAdapter).getPermanentAdapter());
            } else {
                document.setDefaultSupportAdapter(supportAdapter);
            }
        } else {
            document.setDefaultSupportAdapter(new VoidNodeBranchDataAdapter("No support values available"));
        }
    }

    @Override
    public Document readDocument(BufferedInputStream stream) throws Exception {
        Document result = this.createEmptyDocument();
        try (InputStreamReader reader = new InputStreamReader(stream);){
            String[] parts = this.splitDocument(reader);
            String[] names = new String[parts.length];
            int i = 0;
            while (i < names.length) {
                names[i] = "Tree " + i;
                ++i;
            }
            NewickTreeList trees = NewickStringReader.read(parts, this.parameterMap.getNodeBranchDataAdapter("internalNodeNamesAdapter", NodeNameAdapter.getSharedInstance()), this.parameterMap.getNodeBranchDataAdapter("branchLengthAdapter", BranchLengthAdapter.getSharedInstance()), null, false);
            int index = this.parameterMap.getTreeSelector().select(names, trees.treesAsList());
            result.setTree(trees.getTree(index));
            NodeBranchDataAdapter supportAdapter = this.parameterMap.getNodeBranchDataAdapter("internalNodeNamesAdapter", NodeNameAdapter.getSharedInstance());
            NewickReader.setDefaultSupportAdapter(result, supportAdapter, index, trees);
            if (trees.getHiddenDataAdded(index)) {
                NewickReader.displayHiddenDataMessage(this.parameterMap.getApplicationLogger(), 75);
            }
        }
        return result;
    }

    @Override
    public DocumentIterator createIterator(BufferedInputStream stream) {
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(stream));
        return new NewickDocumentIterator(reader, this.loadLogger, this.parameterMap.getNodeBranchDataAdapter("internalNodeNamesAdapter", NodeNameAdapter.getSharedInstance()), this.parameterMap.getNodeBranchDataAdapter("internalNodeNamesAdapter", BranchLengthAdapter.getSharedInstance()));
    }

    private class NewickDocumentIterator
    extends AbstractDocumentIterator {
        private InputStreamReader streamReader;
        private NewickStringReader newickStringReader;

        public NewickDocumentIterator(InputStreamReader reader, ApplicationLogger loadLogger, NodeBranchDataAdapter internalAdapter, NodeBranchDataAdapter branchLengthsAdapter) {
            super(loadLogger, internalAdapter, branchLengthsAdapter, false);
            this.newickStringReader = new NewickStringReader();
            this.streamReader = reader;
        }

        @Override
        protected Document readNext() throws Exception {
            String tree = NewickReader.this.readNextTree(this.streamReader);
            if (tree != null) {
                Document result = NewickReader.this.createEmptyDocument();
                result.setTree(this.newickStringReader.read(tree, this.getParameterMap().getNodeBranchDataAdapter("internalNodeNamesAdapter", null), this.getParameterMap().getNodeBranchDataAdapter("branchLengthAdapter", null), null, false));
                return result;
            }
            return null;
        }
    }

    private static enum Status {
        FREE,
        NAME,
        COMMENT;

    }
}

