/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.newick;

import info.bioinfweb.treegraph.document.io.AbstractFilter;
import info.bioinfweb.treegraph.document.io.ReadWriteFormat;
import info.bioinfweb.treegraph.document.io.TreeFilter;

public class NewickFilter
extends AbstractFilter
implements TreeFilter {
    public static final String[] EXTENSIONS = new String[]{".tre", ".tree", ".trees", ".nwk", ".con"};

    @Override
    public ReadWriteFormat getFormat() {
        return ReadWriteFormat.NEWICK;
    }

    @Override
    public boolean validExtension(String name) {
        name = name.toLowerCase();
        int i = 0;
        while (i < EXTENSIONS.length) {
            if (name.endsWith(EXTENSIONS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Newick file (*.tre*; *.con; *.nwk)";
    }

    @Override
    public String getDefaultExtension() {
        return EXTENSIONS[0];
    }
}

