/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.newick;

import info.bioinfweb.treegraph.document.io.newick.NewickToken;
import info.bioinfweb.treegraph.document.io.newick.TokenType;

public class NewickException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public static final int CHAR_COUNT_BEFORE = 20;
    public static final int CHAR_COUNT_AFTER = 30;
    private int position;
    private String sourceBefore;
    private String sourceAfter;

    private void storePositionInfo(int pos, String source) {
        this.position = pos;
        this.sourceBefore = source.substring(Math.max(0, pos - 20), pos);
        this.sourceAfter = source.substring(pos, Math.min(source.length(), pos + 30));
    }

    public NewickException(int pos, String source, String msg) {
        super(msg);
        this.storePositionInfo(pos, source);
    }

    public NewickException(int pos, String source, TokenType expected, TokenType found) {
        super("Token " + expected.toString() + " expected but token " + found.toString() + " found.");
        this.storePositionInfo(pos, source);
    }

    public NewickException(NewickToken token, String source) {
        super("Unexpected token " + token.getType().toString() + ".");
        this.storePositionInfo(token.getTextPos(), source);
    }

    public static NewickException getUnterminatedNameException(int start, String source) {
        return new NewickException(start, source, "Unterminated name");
    }

    public static NewickException getUnterminatedCommentException(int start, String source) {
        return new NewickException(start, source, "Unterminated comment");
    }

    public int getPosition() {
        return this.position;
    }

    public String getSourceAfter() {
        return this.sourceAfter;
    }

    public String getSourceBefore() {
        return this.sourceBefore;
    }
}

