/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.newick;

import info.bioinfweb.treegraph.document.HiddenDataMap;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextElementData;

public class CommentDataReader {
    public static final char START_SYMBOL = '&';
    public static final char ALLOCATION_SEPARATOR_SYMBOL = ',';
    public static final char ALLOCATION_SYMBOL = '=';
    public static final char FIELD_START_SYMBOL = '{';
    public static final char FIELD_END_SYMBOL = '}';
    public static final char VALUE_SEPARATOR_SYMBOL = ',';
    public static final char STRING_DELIMITER = '\"';
    public static final char INDEX_START_SYMBOL = '[';
    public static final char INDEX_END_SYMBOL = ']';
    public static final String DEFAULT_BRANCH_COLUMN_NAME = "unnamedBranchHotComment";
    public static final String DEFAULT_NODE_COLUMN_NAME = "unnamedNodeHotComment";

    private TextElementData readTextElementData(String text) {
        if (text.startsWith(Character.toString('\"')) && text.endsWith(Character.toString('\"'))) {
            return new TextElementData(text.substring(1, text.length() - 1));
        }
        try {
            return new TextElementData(Double.parseDouble(text));
        }
        catch (NumberFormatException e) {
            return new TextElementData(text);
        }
    }

    private int findFieldEnd(String text, int pos) {
        while (pos < text.length()) {
            if (text.charAt(pos) == ',') {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    private int findAllocationEnd(String text, int start) {
        if (start >= text.length()) {
            return -1;
        }
        int pos = start;
        while (pos < text.length()) {
            switch (text.charAt(pos)) {
                case '{': {
                    pos = this.findFieldEnd(text, pos);
                    if (pos != -1) break;
                    return -1;
                }
                case ',': {
                    return pos;
                }
            }
            ++pos;
        }
        return pos;
    }

    public void read(String comment, Node node, boolean isOnNode) {
        if (comment.startsWith("&")) {
            int start = 1;
            int end = this.findAllocationEnd(comment, start);
            while (end != -1) {
                String[] parts = comment.substring(start, end).split("=");
                if (parts.length == 2) {
                    int j = 0;
                    while (j < parts.length) {
                        parts[j] = parts[j].trim();
                        ++j;
                    }
                    if (parts[1].startsWith("{")) {
                        if (parts[1].endsWith("}")) {
                            String[] values = parts[1].substring(1, parts[1].length() - 1).split(",");
                            int j2 = 0;
                            while (j2 < values.length) {
                                node.getAfferentBranch().getHiddenDataMap().put(String.valueOf(parts[0]) + '[' + j2 + ']', this.readTextElementData(values[j2].trim()));
                                ++j2;
                            }
                        }
                    } else {
                        node.getAfferentBranch().getHiddenDataMap().put(parts[0], this.readTextElementData(parts[1]));
                    }
                }
                start = end + 1;
                end = this.findAllocationEnd(comment, start);
            }
        } else if (comment.length() > 0) {
            HiddenDataMap map = node.getAfferentBranch().getHiddenDataMap();
            String name = DEFAULT_BRANCH_COLUMN_NAME;
            if (isOnNode) {
                name = DEFAULT_NODE_COLUMN_NAME;
            }
            map.put(name, this.readTextElementData(comment));
        }
    }
}

