/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.newick;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.Tree;

public class BranchLengthsScaler {
    private int count = 0;
    private double sum = 0.0;

    private void calculateAverage(Node root) {
        if (root.getAfferentBranch().hasLength()) {
            ++this.count;
            this.sum += root.getAfferentBranch().getLength();
        }
        int i = 0;
        while (i < root.getChildren().size()) {
            this.calculateAverage(root.getChildren().get(i));
            ++i;
        }
    }

    public void setAverageScale(Tree tree, double averageLength, float smallIntervalLength) {
        if (tree.getPaintStart() != null) {
            this.count = 0;
            this.sum = 0.0;
            this.calculateAverage(tree.getPaintStart());
            if (this.count > 0) {
                tree.getFormats().getBranchLengthScale().setInMillimeters((float)(averageLength / (this.sum / (double)this.count)));
            }
        }
        tree.getScaleBar().getFormats().setSmallInterval(Math2.roundFirstSignificantDigit(smallIntervalLength / tree.getFormats().getBranchLengthScale().getInMillimeters()));
    }

    public void setDefaultAverageScale(Tree tree) {
        this.setAverageScale(tree, 4.0, 1.0f);
    }
}

