/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.jphyloio;

import info.bioinfweb.commons.text.StringUtils;
import info.bioinfweb.jphyloio.ReaderStreamDataProvider;
import info.bioinfweb.jphyloio.objecttranslation.implementations.IllegalArgumentExceptionSimpleValueTranslator;
import info.bioinfweb.treegraph.document.format.ScaleValue;

public class ScaleValueTranslator
extends IllegalArgumentExceptionSimpleValueTranslator<ScaleValue> {
    public Class<ScaleValue> getObjectClass() {
        return ScaleValue.class;
    }

    protected ScaleValue parseValue(String representation, ReaderStreamDataProvider<?> streamDataProvider) throws IllegalArgumentException {
        representation = representation.trim();
        try {
            boolean isInUnits;
            float value;
            if (representation.endsWith("mm")) {
                value = Float.parseFloat(StringUtils.cutEnd(representation, "mm".length()));
                isInUnits = false;
            } else if (representation.endsWith("u")) {
                value = Float.parseFloat(StringUtils.cutEnd(representation, "u".length()));
                isInUnits = true;
            } else {
                throw new IllegalArgumentException("Scale values must end with a unit, either \"u\" or \"mm\" (" + representation + ").");
            }
            ScaleValue result = new ScaleValue();
            if (isInUnits) {
                result.setInUnits(value);
            } else {
                result.setInMillimeters(value);
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

