/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.ancestralstate;

import info.bioinfweb.commons.SystemUtils;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.NodeType;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.HashSet;

public class BayesTraitsCommandsWriter {
    public static final String INTERNAL_NODE_NAME_PREFIX = "internalNode";
    public static final DecimalFormat DECIMAL_INTEGER_FORMAT = new DecimalFormat("#.########");

    public void write(Writer writer, String commandName, Node[] nodes, NodeBranchDataAdapter leavesAdapter, NodeBranchDataAdapter internalNodesAdapter) throws IOException {
        int nodeCount = 0;
        HashSet<String> internalNodeNameSet = new HashSet<String>();
        try {
            Node[] nodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeArray[n2];
                if (!node.isLeaf() && !node.equals(MainFrame.getInstance().getActiveTreeFrame().getTreeViewPanel().getDocument().getTree().getPaintStart())) {
                    String internalNodeName = internalNodesAdapter.getText(node);
                    if (internalNodesAdapter.isDecimal(node)) {
                        internalNodeName = INTERNAL_NODE_NAME_PREFIX + DECIMAL_INTEGER_FORMAT.format(internalNodesAdapter.getDecimal(node));
                    }
                    if (internalNodeName != null && !internalNodeName.equals("")) {
                        if (internalNodeNameSet.add(internalNodeName)) {
                            this.writeCommand(writer, commandName, node, internalNodeName, leavesAdapter, internalNodesAdapter);
                        } else {
                            int internalCount = 2;
                            while (!internalNodeNameSet.add(String.valueOf(internalNodeName) + "_" + internalCount)) {
                                ++internalCount;
                            }
                            this.writeCommand(writer, commandName, node, String.valueOf(internalNodeName) + "_" + internalCount, leavesAdapter, internalNodesAdapter);
                        }
                    } else {
                        ++nodeCount;
                        while (!internalNodeNameSet.add(INTERNAL_NODE_NAME_PREFIX + nodeCount)) {
                            ++nodeCount;
                        }
                        this.writeCommand(writer, commandName, node, INTERNAL_NODE_NAME_PREFIX + nodeCount, leavesAdapter, internalNodesAdapter);
                    }
                }
                ++n2;
            }
        }
        finally {
            writer.close();
        }
    }

    private void writeCommand(Writer writer, String commandType, Node node, String internalNodeName, NodeBranchDataAdapter leavesAdapter, NodeBranchDataAdapter internalNodesAdapter) throws IOException {
        Node[] terminalNodes;
        writer.write(String.valueOf(commandType) + internalNodeName);
        Node[] nodeArray = terminalNodes = (Node[])TreeSerializer.getElementsInSubtree((Node)node, (NodeType)NodeType.LEAVES, Node.class);
        int n = terminalNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node terminal = nodeArray[n2];
            String terminalName = leavesAdapter.getText(terminal);
            if (terminalName.contains(" ")) {
                terminalName = terminalName.replace(" ", "_");
            }
            writer.write(" " + terminalName);
            ++n2;
        }
        writer.write(SystemUtils.LINE_SEPARATOR);
    }
}

