/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io.ancestralstate;

import info.bioinfweb.commons.Math2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.map.ListOrderedMap;

public class AncestralStateData {
    private String name;
    private List<String> leafNames = new ArrayList<String>();
    private ListOrderedMap<String, ListOrderedMap<String, ProbabilityData>> siteMap = new ListOrderedMap();

    public AncestralStateData(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLeafNames() {
        return this.leafNames;
    }

    public Iterator<String> getSiteIterator() {
        return this.siteMap.keySet().iterator();
    }

    public Iterator<String> getKeyIterator(String siteName) {
        return ((ListOrderedMap)this.siteMap.get((Object)siteName)).keySet().iterator();
    }

    public double getProbability(String siteName, String stateName) {
        ProbabilityData data = (ProbabilityData)((ListOrderedMap)this.siteMap.get((Object)siteName)).get((Object)stateName);
        if (data == null) {
            return Double.NaN;
        }
        return data.probability;
    }

    public int getCharacterStateCount() {
        int count = 0;
        Iterator iterator = this.siteMap.keySet().iterator();
        while (iterator.hasNext()) {
            count += ((ListOrderedMap)this.siteMap.get(iterator.next())).size();
        }
        return count;
    }

    public int getStateCountPerSite(String character) {
        return ((ListOrderedMap)this.siteMap.get((Object)character)).size();
    }

    public int getSiteCount() {
        return this.siteMap.size();
    }

    public void normalizeProbability(String siteName, String stateName) {
        ProbabilityData data = (ProbabilityData)((ListOrderedMap)this.siteMap.get((Object)siteName)).get((Object)stateName);
        if (data != null) {
            data.probability /= (double)data.elementCount;
            data.elementCount = -1L;
        }
    }

    public void addToProbability(String siteName, String stateName, String addend) {
        if (this.siteMap.get((Object)siteName) == null) {
            this.siteMap.put((Object)siteName, (Object)new ListOrderedMap());
        }
        if (!addend.equals("--")) {
            double addValue = Math2.parseDouble(addend);
            ProbabilityData data = (ProbabilityData)((ListOrderedMap)this.siteMap.get((Object)siteName)).get((Object)stateName);
            if (data == null) {
                data = new ProbabilityData();
                ((ListOrderedMap)this.siteMap.get((Object)siteName)).put((Object)stateName, (Object)data);
            }
            if (data.elementCount == -1L) {
                throw new IllegalStateException("Value is already normalized.");
            }
            data.probability += addValue;
            ++data.elementCount;
        }
    }

    private static class ProbabilityData {
        public double probability = 0.0;
        public long elementCount = 0L;

        private ProbabilityData() {
        }
    }
}

