/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io;

import info.bioinfweb.treegraph.document.io.AbstractFilter;
import info.bioinfweb.treegraph.document.io.DocumentReader;
import info.bioinfweb.treegraph.document.io.DocumentWriter;
import info.bioinfweb.treegraph.document.io.ReadWriteFormat;
import info.bioinfweb.treegraph.document.io.SingleReadWriteFactory;
import info.bioinfweb.treegraph.document.io.jphyloio.NeXMLFactory;
import info.bioinfweb.treegraph.document.io.newick.NewickFactory;
import info.bioinfweb.treegraph.document.io.nexus.NexusFactory;
import info.bioinfweb.treegraph.document.io.phyloxml.PhyloXMLFactory;
import info.bioinfweb.treegraph.document.io.tgf.TGFFactory;
import info.bioinfweb.treegraph.document.io.xtg.XTGFactory;
import java.io.File;
import java.util.EnumMap;

public class ReadWriteFactory {
    private static ReadWriteFactory firstInstance = null;
    private EnumMap<ReadWriteFormat, SingleReadWriteFactory> factories = new EnumMap(ReadWriteFormat.class);

    private ReadWriteFactory() {
        this.fillList();
    }

    private void fillList() {
        this.factories.put(ReadWriteFormat.XTG, new XTGFactory());
        this.factories.put(ReadWriteFormat.NEWICK, new NewickFactory());
        this.factories.put(ReadWriteFormat.NEXUS, new NexusFactory());
        this.factories.put(ReadWriteFormat.NEXML, new NeXMLFactory());
        this.factories.put(ReadWriteFormat.TGF, new TGFFactory());
        this.factories.put(ReadWriteFormat.PHYLO_XML, new PhyloXMLFactory());
    }

    public static ReadWriteFactory getInstance() {
        if (firstInstance == null) {
            firstInstance = new ReadWriteFactory();
        }
        return firstInstance;
    }

    public ReadWriteFormat formatByFileName(String name) {
        ReadWriteFormat[] readWriteFormatArray = ReadWriteFormat.values();
        int n = readWriteFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReadWriteFormat f = readWriteFormatArray[n2];
            if (this.factories.get((Object)f).getFilter().validExtension(name)) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    public ReadWriteFormat formatByFile(File file) {
        ReadWriteFormat result = this.formatByFileName(file.getName());
        if (result != null) {
            if (result.equals((Object)ReadWriteFormat.NEWICK) || result.equals((Object)ReadWriteFormat.NEXUS)) {
                result = this.getFilter(ReadWriteFormat.NEXUS).accept(file) ? ReadWriteFormat.NEXUS : ReadWriteFormat.NEWICK;
            } else if (result.equals((Object)ReadWriteFormat.XTG) || result.equals((Object)ReadWriteFormat.PHYLO_XML) || result.equals((Object)ReadWriteFormat.NEXML)) {
                result = file.getAbsolutePath().endsWith(".xtg") || this.getFilter(ReadWriteFormat.XTG).accept(file) ? ReadWriteFormat.XTG : (this.getFilter(ReadWriteFormat.PHYLO_XML).accept(file) ? ReadWriteFormat.PHYLO_XML : (this.getFilter(ReadWriteFormat.NEXML).accept(file) ? ReadWriteFormat.NEXML : null));
            }
        }
        return result;
    }

    public DocumentReader getReader(File file) {
        ReadWriteFormat f = this.formatByFile(file);
        if (f != null) {
            return this.getReader(f);
        }
        return null;
    }

    public boolean hasReader(ReadWriteFormat f) {
        return this.factories.get((Object)f).hasReader();
    }

    public boolean hasWriter(ReadWriteFormat f) {
        return this.factories.get((Object)f).hasWriter();
    }

    public DocumentReader getReader(ReadWriteFormat f) {
        return this.factories.get((Object)f).getReader();
    }

    public DocumentWriter getWriter(ReadWriteFormat f) {
        return this.factories.get((Object)f).getWriter();
    }

    public AbstractFilter getFilter(ReadWriteFormat f) {
        return this.factories.get((Object)f).getFilter();
    }

    public int size() {
        return this.factories.size();
    }
}

