/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io;

import info.bioinfweb.commons.io.XMLUtils;
import info.bioinfweb.treegraph.document.io.AbstractFilter;
import java.io.File;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public abstract class AbstractXMLFilter
extends AbstractFilter {
    public static final String XML_EXTENSION = ".xml";
    private String rootName;

    public AbstractXMLFilter(String rootName) {
        this.rootName = rootName;
    }

    @Override
    public boolean accept(File f) {
        boolean result = super.accept(f);
        if (result && f.getAbsolutePath().endsWith(XML_EXTENSION)) {
            try {
                result = XMLUtils.readRootElement(f).getName().getLocalPart().equals(this.rootName);
            }
            catch (IOException e) {
                result = false;
            }
            catch (XMLStreamException e) {
                result = false;
            }
        }
        return result;
    }
}

