/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io;

import info.bioinfweb.commons.io.XMLUtils;
import info.bioinfweb.commons.log.ApplicationLogger;
import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.io.DocumentIterator;
import info.bioinfweb.treegraph.document.io.DocumentReader;
import info.bioinfweb.treegraph.document.io.ReadWriteParameterMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public abstract class AbstractDocumentReader
implements DocumentReader {
    private boolean saveFileName = false;
    protected ApplicationLogger loadLogger = null;
    protected ReadWriteParameterMap parameterMap = null;
    protected Document document = null;

    public AbstractDocumentReader(boolean saveFileName) {
        this.saveFileName = saveFileName;
    }

    protected void reachElementEnd(XMLEventReader reader, StartElement element) throws XMLStreamException {
        this.reachElementEnd(reader, "The XML element \"" + element.getName().toString() + "\" and possible subelements ");
    }

    protected void reachElementEnd(XMLEventReader reader, String elementDescription) throws XMLStreamException {
        if (XMLUtils.reachElementEnd(reader) && this.loadLogger != null) {
            this.loadLogger.addWarning(String.valueOf(elementDescription) + " are not recognized at this position and were skipped. If you " + "are loading an XTG file and save it to XTG again later these elements will be lost.");
        }
    }

    @Override
    public Document read(InputStream stream) throws Exception {
        return this.read(stream, new ReadWriteParameterMap());
    }

    @Override
    public Document read(File file) throws Exception {
        return this.read(file, new ReadWriteParameterMap());
    }

    @Override
    public Document read(InputStream stream, ReadWriteParameterMap properties) throws Exception {
        this.parameterMap = properties;
        this.loadLogger = properties.getApplicationLogger();
        return this.readDocument(new BufferedInputStream(stream));
    }

    public abstract Document readDocument(BufferedInputStream var1) throws Exception;

    @Override
    public Document read(File file, ReadWriteParameterMap properties) throws Exception {
        Document result = this.read(new FileInputStream(file), properties);
        if (this.saveFileName) {
            result.setFile(file);
        } else {
            result.setDefaultName(result.getDefaultName().replaceAll(Main.getInstance().getNameManager().getPrefix(), file.getName()));
        }
        return result;
    }

    public abstract DocumentIterator createIterator(BufferedInputStream var1) throws Exception;

    @Override
    public DocumentIterator readAll(InputStream stream, ReadWriteParameterMap properties) throws Exception {
        this.parameterMap = properties;
        this.loadLogger = properties.getApplicationLogger();
        return this.createIterator(new BufferedInputStream(stream));
    }

    @Override
    public DocumentIterator readAll(File file, ReadWriteParameterMap properties) throws Exception {
        return this.readAll(new FileInputStream(file), properties);
    }

    protected Document createEmptyDocument() {
        return new Document(this.parameterMap.getBoolean("registerFileChooser", true));
    }
}

