/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.io;

import info.bioinfweb.commons.log.ApplicationLogger;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.io.DocumentIterator;
import info.bioinfweb.treegraph.document.io.ReadWriteParameterMap;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;

public abstract class AbstractDocumentIterator
implements DocumentIterator {
    private ReadWriteParameterMap parameterMap = new ReadWriteParameterMap();
    private Document nextDocument = null;
    private boolean beforeFirst = true;

    public AbstractDocumentIterator(ApplicationLogger loadLogger, NodeBranchDataAdapter internalAdapter, NodeBranchDataAdapter branchLengthsAdapter, boolean translateInternalNodes) {
        this.parameterMap.putApplicationLogger(loadLogger);
        this.parameterMap.put("internalNodeNamesAdapter", internalAdapter);
        this.parameterMap.put("branchLengthAdapter", branchLengthsAdapter);
        this.parameterMap.put("translateInternalNodeNames", translateInternalNodes);
    }

    public ReadWriteParameterMap getParameterMap() {
        return this.parameterMap;
    }

    private Document getNextDocument() throws Exception {
        if (this.beforeFirst) {
            this.nextDocument = this.readNext();
            this.beforeFirst = false;
        }
        return this.nextDocument;
    }

    protected abstract Document readNext() throws Exception;

    @Override
    public Document next() throws Exception {
        Document result = this.getNextDocument();
        this.nextDocument = this.readNext();
        return result;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.getNextDocument() != null;
    }

    @Override
    public Document peek() throws Exception {
        return this.getNextDocument();
    }
}

