/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.format;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.format.DistanceValue;

public class ScaleValue {
    private boolean inScaleUnits = true;
    private DistanceValue distanceValue = new DistanceValue();

    public ScaleValue() {
    }

    public ScaleValue(float inMillimeters) {
        this.setInMillimeters(inMillimeters);
    }

    public boolean isInScaleUnits() {
        return this.inScaleUnits;
    }

    public void setInUnits(float units) {
        this.inScaleUnits = true;
        this.distanceValue.setInMillimeters(units);
    }

    public float getInUnits(float branchLengthScale) {
        if (this.inScaleUnits) {
            return this.distanceValue.getInMillimeters();
        }
        return ScaleValue.millimetersToUnits(this.distanceValue.getInMillimeters(), branchLengthScale);
    }

    public void setInMillimeters(float value) {
        this.inScaleUnits = false;
        this.distanceValue.setInMillimeters(value);
    }

    public float getInMillimeters(float branchLengthScale) {
        if (this.inScaleUnits) {
            return ScaleValue.millimetersToUnits(this.distanceValue.getInMillimeters(), branchLengthScale);
        }
        return this.distanceValue.getInMillimeters();
    }

    public void setInPixels(float value, float pixelsPerMillimeter) {
        this.inScaleUnits = false;
        this.distanceValue.setInPixels(value, pixelsPerMillimeter);
    }

    public float getInPixels(float pixelsPerMillimeter, float branchLengthScale) {
        return DistanceValue.millimetersToPixels(this.getInMillimeters(branchLengthScale), pixelsPerMillimeter);
    }

    public int getRoundedInPixels(float pixelsPerMillimeter, float branchLengthScale) {
        return Math2.roundUp(this.getInPixels(pixelsPerMillimeter, branchLengthScale));
    }

    public void setInPoints(float value) {
        this.inScaleUnits = false;
        this.distanceValue.setInPoints(value);
    }

    public float getInPoints(float mmPerBranchLength) {
        return DistanceValue.millimetersToPoints(this.getInMillimeters(mmPerBranchLength));
    }

    public float getStoredValue() {
        return this.distanceValue.getInMillimeters();
    }

    public static float unitsToMillimeters(float units, float mmPerBranchLength) {
        return mmPerBranchLength * units;
    }

    public static float millimetersToUnits(float mm, float branchLengthScale) {
        return mm / branchLengthScale;
    }

    public static float unitsToPoints(float units, float mmPerBranch) {
        return DistanceValue.millimetersToPoints(ScaleValue.unitsToMillimeters(units, mmPerBranch));
    }

    public static float pointsToUnits(float points, float mmPerBranchLength) {
        return ScaleValue.millimetersToUnits(DistanceValue.pointsToMillimeters(points), mmPerBranchLength);
    }

    public static float unitsToPixels(float units, float pixelsPerMillimeter, float mmPerBranchLength) {
        return DistanceValue.millimetersToPixels(ScaleValue.unitsToMillimeters(units, mmPerBranchLength), pixelsPerMillimeter);
    }

    public static float branchLengthToDistance(float units, float branchLengthScale) {
        return branchLengthScale * units;
    }

    public void assign(ScaleValue other) {
        if (other.isInScaleUnits()) {
            this.setInUnits(other.distanceValue.getInMillimeters());
        } else {
            this.setInMillimeters(other.distanceValue.getInMillimeters());
        }
    }

    public String toString() {
        String unit = this.isInScaleUnits() ? "u" : "mm";
        return String.valueOf(this.getStoredValue()) + unit;
    }
}

