/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.format;

import info.bioinfweb.treegraph.document.format.ConcreteTextFormats;
import info.bioinfweb.treegraph.document.format.DistanceValue;
import info.bioinfweb.treegraph.document.format.LineFormats;
import info.bioinfweb.treegraph.document.format.ScaleBarAlignment;
import info.bioinfweb.treegraph.document.format.ScaleValue;
import java.awt.Color;

public class ScaleBarFormats
extends ConcreteTextFormats
implements LineFormats {
    public static final ScaleBarAlignment DEFAULT_ALIGNMENT = ScaleBarAlignment.LEFT;
    public static final float DEFAULT_TREE_DISTANCE_IN_MM = 2.0f;
    public static final float DEFAULT_WIDTH_IN_MM = 20.0f;
    public static final float DEFAULT_HEIGHT_IN_MM = 3.0f;
    public static final float DEFAULT_SMALL_INTERVAL = 10.0f;
    public static final float DEFAULT_SMALL_INTERVAL_IN_MM = 1.0f;
    public static final int DEFAULT_LONG_INTERVAL = 10;
    public static final boolean DEFAULT_START_LEFT = true;
    public static final boolean DEFAULT_INCREASING = true;
    public static final float DEFAULT_TEXT_HEIGHT_IN_MM = 4.0f;
    private DistanceValue lineWidth = new DistanceValue(0.3f);
    private Color lineColor = LineFormats.DEFAULT_LINE_COLOR;
    private ScaleBarAlignment alignment = DEFAULT_ALIGNMENT;
    private DistanceValue treeDistance = new DistanceValue(2.0f);
    private ScaleValue width = new ScaleValue(20.0f);
    private DistanceValue height = new DistanceValue(3.0f);
    private float smallInterval = 10.0f;
    private int longInterval = 10;
    private boolean startLeft = true;
    private boolean increasing = true;

    public ScaleBarFormats() {
        this.getTextHeight().setInMillimeters(4.0f);
    }

    @Override
    public Color getLineColor() {
        return this.lineColor;
    }

    @Override
    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    @Override
    public DistanceValue getLineWidth() {
        return this.lineWidth;
    }

    public ScaleBarAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(ScaleBarAlignment scaleAnchor) {
        this.alignment = scaleAnchor;
    }

    public DistanceValue getTreeDistance() {
        return this.treeDistance;
    }

    public ScaleValue getWidth() {
        return this.width;
    }

    public DistanceValue getHeight() {
        return this.height;
    }

    public int getLongInterval() {
        return this.longInterval;
    }

    public void setLongInterval(int longInterval) {
        this.longInterval = longInterval;
    }

    public float getSmallInterval() {
        return this.smallInterval;
    }

    public void setSmallInterval(float smallInterval) {
        this.smallInterval = smallInterval;
    }

    public boolean isIncreasing() {
        return this.increasing;
    }

    public void setIncreasing(boolean increasing) {
        this.increasing = increasing;
    }

    public boolean isStartLeft() {
        return this.startLeft;
    }

    public void setStartLeft(boolean startLeft) {
        this.startLeft = startLeft;
    }

    @Override
    public void assignLineFormats(LineFormats other) {
        this.setLineColor(other.getLineColor());
        this.getLineWidth().assign(other.getLineWidth());
    }

    public void assignScaleBarFormats(ScaleBarFormats other) {
        this.setAlignment(other.getAlignment());
        this.getTreeDistance().assign(other.getTreeDistance());
        this.getWidth().assign(other.getWidth());
        this.getHeight().assign(other.getHeight());
        this.setSmallInterval(other.getSmallInterval());
        this.setLongInterval(other.getLongInterval());
        this.setStartLeft(other.isStartLeft());
        this.setIncreasing(other.isIncreasing());
    }

    public void assign(ScaleBarFormats other) {
        this.assignTextFormats(other);
        this.assignLineFormats(other);
        this.assignScaleBarFormats(other);
    }

    @Override
    public ScaleBarFormats clone() {
        ScaleBarFormats result = new ScaleBarFormats();
        result.assign(this);
        return result;
    }
}

