/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.format;

import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.PieColorManager;
import info.bioinfweb.treegraph.document.format.ConcreteTextFormats;
import info.bioinfweb.treegraph.document.format.DistanceValue;
import info.bioinfweb.treegraph.document.format.GraphicalLabelFormats;
import info.bioinfweb.treegraph.document.format.LineFormats;
import info.bioinfweb.treegraph.document.format.PieChartLabelCaptionContentType;
import info.bioinfweb.treegraph.document.format.PieChartLabelCaptionLinkType;
import info.bioinfweb.treegraph.document.format.TextFormats;
import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PieChartLabelFormats
extends GraphicalLabelFormats
implements LineFormats,
TextFormats {
    public static final boolean DEFAULT_SHOW_INTERNAL_LINES = true;
    public static final boolean DEFAULT_SHOW_LINES_FOR_ZERO = false;
    public static final boolean DEFAULT_SHOW_TITLE = false;
    public static final PieChartLabelCaptionContentType DEFAULT_CAPTIONS_CONTENT_TYPE = PieChartLabelCaptionContentType.NONE;
    public static final PieChartLabelCaptionLinkType DEFAULT_CAPTIONS_LINK_TYPE = PieChartLabelCaptionLinkType.STRAIGHT_LINES;
    private List<Color> pieColors = new ArrayList<Color>();
    private boolean showInternalLines = true;
    private boolean showLinesForZero = false;
    private boolean showTitle = false;
    private PieChartLabelCaptionContentType captionsContentType = DEFAULT_CAPTIONS_CONTENT_TYPE;
    private PieChartLabelCaptionLinkType captionsLinkType = DEFAULT_CAPTIONS_LINK_TYPE;
    private TextFormats titleTextFormats = new ConcreteTextFormats();
    private TextFormats captionsTextFormats = new ConcreteTextFormats();

    public PieChartLabelFormats(Label owner, boolean above, int line, int linePosition) {
        super(owner, above, line, linePosition);
    }

    public PieChartLabelFormats(Label owner) {
        super(owner);
    }

    public boolean addPieColor(Color color) {
        return this.pieColors.add(color);
    }

    public void addPieColor(int index, Color color) {
        this.pieColors.add(index, color);
    }

    public Color getPieColor(int index) {
        if (this.pieColorCount() <= index) {
            PieColorManager.getInstance().addDefaultColors(this, index + 1);
        }
        return this.pieColors.get(index);
    }

    public Color setPieColor(int index, Color color) {
        if (this.pieColorCount() <= index) {
            PieColorManager.getInstance().addDefaultColors(this, index + 1);
        }
        return this.pieColors.set(index, color);
    }

    public int pieColorCount() {
        return this.pieColors.size();
    }

    public boolean isShowInternalLines() {
        return this.showInternalLines;
    }

    public void setShowInternalLines(boolean showInternalLines) {
        this.showInternalLines = showInternalLines;
    }

    public boolean isShowLinesForZero() {
        return this.showLinesForZero;
    }

    public void setShowLinesForZero(boolean showLinesForZero) {
        this.showLinesForZero = showLinesForZero;
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
    }

    public PieChartLabelCaptionContentType getCaptionsContentType() {
        return this.captionsContentType;
    }

    public void setCaptionsContentType(PieChartLabelCaptionContentType captionsContentType) {
        if (captionsContentType == null) {
            throw new NullPointerException("The caption content type must not be null.");
        }
        this.captionsContentType = captionsContentType;
    }

    public PieChartLabelCaptionLinkType getCaptionsLinkType() {
        return this.captionsLinkType;
    }

    public void setCaptionsLinkType(PieChartLabelCaptionLinkType captionsLinkType) {
        if (captionsLinkType == null) {
            throw new NullPointerException("The caption link type must not be null.");
        }
        this.captionsLinkType = captionsLinkType;
    }

    @Override
    public String getFontName() {
        return this.titleTextFormats.getFontName();
    }

    @Override
    public void setFontName(String fontName) {
        this.titleTextFormats.setFontName(fontName);
    }

    @Override
    public DistanceValue getTextHeight() {
        return this.titleTextFormats.getTextHeight();
    }

    @Override
    public float getDescent() {
        return this.titleTextFormats.getDescent();
    }

    @Override
    public boolean hasTextStyle(int style) {
        return this.titleTextFormats.hasTextStyle(style);
    }

    @Override
    public int getTextStyle() {
        return this.titleTextFormats.getTextStyle();
    }

    @Override
    public void setTextStyle(int style) {
        this.titleTextFormats.setTextStyle(style);
    }

    @Override
    public void addTextStyle(int style) {
        this.titleTextFormats.addTextStyle(style);
    }

    @Override
    public void removeTextStyle(int style) {
        this.titleTextFormats.removeTextStyle(style);
    }

    @Override
    public Font getFont(float pixelsPerMillimeter) {
        return this.titleTextFormats.getFont(pixelsPerMillimeter);
    }

    @Override
    public Color getTextColor() {
        return this.titleTextFormats.getTextColor();
    }

    @Override
    public void setTextColor(Color textColor) {
        this.titleTextFormats.setTextColor(textColor);
    }

    @Override
    public Locale getLocale() {
        return this.titleTextFormats.getLocale();
    }

    @Override
    public void setLocale(Locale locale) {
        this.titleTextFormats.setLocale(locale);
    }

    @Override
    public DecimalFormat getDecimalFormat() {
        return this.titleTextFormats.getDecimalFormat();
    }

    @Override
    public void setDecimalFormat(DecimalFormat decimalFormat, Locale locale) {
        this.titleTextFormats.setDecimalFormat(decimalFormat, locale);
    }

    public TextFormats getCaptionsTextFormats() {
        return this.captionsTextFormats;
    }

    @Override
    public void assignTextFormats(TextFormats other) {
        this.titleTextFormats.assignTextFormats(other);
    }

    public void assignPieChartLabelFormats(PieChartLabelFormats other) {
        this.pieColors.clear();
        this.pieColors.addAll(other.pieColors);
        this.setShowInternalLines(other.isShowInternalLines());
        this.setShowLinesForZero(other.isShowLinesForZero());
        this.setShowTitle(other.isShowTitle());
        this.setCaptionsContentType(other.getCaptionsContentType());
        this.setCaptionsLinkType(other.getCaptionsLinkType());
        this.getCaptionsTextFormats().assignTextFormats(other.getCaptionsTextFormats());
    }

    public void assign(PieChartLabelFormats other) {
        this.assignLabelFormats(other);
        this.assignLineFormats(other);
        this.assignGraphicalLabelFormats(other);
        this.assignTextFormats(other);
        this.assignPieChartLabelFormats(other);
    }

    @Override
    public PieChartLabelFormats clone() {
        PieChartLabelFormats result = new PieChartLabelFormats(null);
        result.assign(this);
        return result;
    }
}

