/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.format;

import info.bioinfweb.treegraph.document.format.DistanceValue;

public class Margin {
    private DistanceValue left = null;
    private DistanceValue top = null;
    private DistanceValue right = null;
    private DistanceValue bottom = null;

    public Margin() {
        this.left = new DistanceValue();
        this.top = new DistanceValue();
        this.right = new DistanceValue();
        this.bottom = new DistanceValue();
    }

    public Margin(float margin) {
        this.left = new DistanceValue(margin);
        this.top = new DistanceValue(margin);
        this.right = new DistanceValue(margin);
        this.bottom = new DistanceValue(margin);
    }

    public Margin(float left, float top, float right, float bottom) {
        this.left = new DistanceValue(left);
        this.top = new DistanceValue(top);
        this.right = new DistanceValue(right);
        this.bottom = new DistanceValue(bottom);
    }

    public Margin(DistanceValue left, DistanceValue top, DistanceValue right, DistanceValue bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public DistanceValue getBottom() {
        return this.bottom;
    }

    public DistanceValue getLeft() {
        return this.left;
    }

    public DistanceValue getRight() {
        return this.right;
    }

    public DistanceValue getTop() {
        return this.top;
    }

    public void assign(Margin other) {
        this.getLeft().assign(other.getLeft());
        this.getTop().assign(other.getTop());
        this.getRight().assign(other.getRight());
        this.getBottom().assign(other.getBottom());
    }

    protected Margin clone() {
        return new Margin(this.getLeft().clone(), this.getTop().clone(), this.getRight().clone(), this.getBottom().clone());
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.bottom == null ? 0 : this.bottom.hashCode());
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        result = 31 * result + (this.top == null ? 0 : this.top.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Margin other = (Margin)obj;
        if (this.bottom == null ? other.bottom != null : !this.bottom.equals(other.bottom)) {
            return false;
        }
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        if (this.right == null ? other.right != null : !this.right.equals(other.right)) {
            return false;
        }
        return !(this.top == null ? other.top != null : !this.top.equals(other.top));
    }
}

