/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.format;

import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.format.ConcreteTextFormats;
import info.bioinfweb.treegraph.document.format.CornerRadiusFormats;
import info.bioinfweb.treegraph.document.format.DistanceValue;
import info.bioinfweb.treegraph.document.format.ElementFormats;
import info.bioinfweb.treegraph.document.format.LegendStyle;
import info.bioinfweb.treegraph.document.format.LineFormats;
import info.bioinfweb.treegraph.document.format.Margin;
import info.bioinfweb.treegraph.document.format.TextFormats;
import info.bioinfweb.treegraph.document.format.TextOrientation;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintType;
import java.awt.Color;

public class LegendFormats
extends ConcreteTextFormats
implements ElementFormats,
LineFormats,
TextFormats,
CornerRadiusFormats,
Cloneable {
    public static final TextOrientation DEFAULT_ORIENTATION = TextOrientation.HORIZONTAL;
    public static final LegendStyle DEFAULT_LEGEND_STYLE = LegendStyle.BRACKET;
    public static final float DEFAULT_SPACING_IN_MM = 1.0f;
    public static final int DEFAULT_POSITION = 0;
    private Legend owner = null;
    private TextOrientation orientation = DEFAULT_ORIENTATION;
    private LegendStyle legendStyle = DEFAULT_LEGEND_STYLE;
    private Color lineColor = LineFormats.DEFAULT_LINE_COLOR;
    private DistanceValue lineWidth = new DistanceValue(0.3f);
    private DistanceValue cornerRadius = new DistanceValue(1.0f);
    private Margin margin = new Margin(1.0f, 0.0f, 1.0f, 0.0f);
    private DistanceValue spacing = new DistanceValue(1.0f);
    private int position = 0;
    private DistanceValue minTreeDistance = new DistanceValue(0.0f);
    private String[] anchorNames = new String[2];

    public LegendFormats(Legend owner) {
        this.owner = owner;
        int i = 0;
        while (i < 2) {
            this.setAnchor(i, null);
            ++i;
        }
    }

    public Legend getOwner() {
        return this.owner;
    }

    public void setOwner(Legend owner) {
        this.owner = owner;
    }

    public TextOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(TextOrientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public Color getLineColor() {
        return this.lineColor;
    }

    @Override
    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    @Override
    public DistanceValue getLineWidth() {
        return this.lineWidth;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        if (this.position != position) {
            this.position = position;
            if (this.getOwner() != null) {
                this.getOwner().reinsert();
            }
        }
    }

    public DistanceValue getMinTreeDistance() {
        return this.minTreeDistance;
    }

    public LegendStyle getLegendStyle() {
        return this.legendStyle;
    }

    public void setLegendStyle(LegendStyle style) {
        this.legendStyle = style;
    }

    public Margin getMargin() {
        return this.margin;
    }

    public DistanceValue getSpacing() {
        return this.spacing;
    }

    @Override
    public DistanceValue getCornerRadius() {
        return this.cornerRadius;
    }

    public String getAnchorName(int no) {
        return this.anchorNames[no];
    }

    public void setAnchorName(int no, String value) {
        this.anchorNames[no] = value;
    }

    public Node getAnchor(int no) {
        return this.getOwner().getLegends().getTree().getNodeByUniqueName(this.getAnchorName(no));
    }

    public void setAnchor(int no, Node node) {
        this.anchorNames[no] = node == null ? null : node.getUniqueName();
    }

    public void sortAnchors(PositionPaintType type) {
        if (this.hasOneAnchor()) {
            if (this.getAnchor(0) == null) {
                this.anchorNames[0] = this.anchorNames[1];
                this.anchorNames[1] = null;
            }
        } else if (this.getAnchor(0).getPosition(type).getTop().getInMillimeters() > this.getAnchor(1).getPosition(type).getTop().getInMillimeters()) {
            String temp = this.anchorNames[0];
            this.anchorNames[0] = this.anchorNames[1];
            this.anchorNames[1] = temp;
        }
    }

    public boolean hasOneAnchor() {
        return this.getAnchorName(0) == null || this.getAnchorName(1) == null;
    }

    @Override
    public void assignLineFormats(LineFormats other) {
        this.setLineColor(other.getLineColor());
        this.getLineWidth().assign(other.getLineWidth());
    }

    @Override
    public void assignCornerRadiusFormats(CornerRadiusFormats other) {
        this.getCornerRadius().assign(other.getCornerRadius());
    }

    public void assignLegendPosition(LegendFormats other) {
        this.setPosition(other.getPosition());
        int i = 0;
        while (i <= 1) {
            this.setAnchorName(i, other.getAnchorName(i));
            ++i;
        }
        this.getMinTreeDistance().assign(other.getMinTreeDistance());
    }

    public void assignLegendFormats(LegendFormats other) {
        this.setOrientation(other.getOrientation());
        this.setLegendStyle(other.getLegendStyle());
        this.getMargin().assign(other.getMargin());
        this.getSpacing().assign(other.getSpacing());
    }

    public void assign(LegendFormats other) {
        this.assignTextFormats(other);
        this.assignLineFormats(other);
        this.assignCornerRadiusFormats(other);
        this.assignLegendFormats(other);
        this.assignLegendPosition(other);
        this.setOwner(other.getOwner());
    }

    @Override
    public LegendFormats clone() {
        LegendFormats result = new LegendFormats(null);
        result.assign(this);
        return result;
    }
}

