/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.document.format;

import info.bioinfweb.commons.graphics.GraphicsUtils;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Legends;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.format.LineFormats;
import info.bioinfweb.treegraph.document.format.TextFormats;
import java.awt.Color;

public class FormatUtils {
    public static int MIN_COLOR_DIFFERENCE = 150;

    public static Color getLineColor(Document document) {
        return GraphicsUtils.getContrastColor(LineFormats.DEFAULT_LINE_COLOR, document.getTree().getFormats().getBackgroundColor(), MIN_COLOR_DIFFERENCE);
    }

    public static Color getTextColor(Document document) {
        return GraphicsUtils.getContrastColor(TextFormats.DEFAULT_TEXT_COLOR, document.getTree().getFormats().getBackgroundColor(), MIN_COLOR_DIFFERENCE);
    }

    public static Node createNode(Node parent) {
        Node result = Node.newInstanceWithBranch();
        result.getFormats().assign(parent.getFormats());
        result.getAfferentBranch().getFormats().assign(parent.getAfferentBranch().getFormats());
        return result;
    }

    public static Node createNode(Document document) {
        Node result = Node.newInstanceWithBranch();
        Color lineColor = FormatUtils.getLineColor(document);
        result.getFormats().setLineColor(lineColor);
        result.getAfferentBranch().getFormats().setLineColor(lineColor);
        result.getFormats().setTextColor(FormatUtils.getTextColor(document));
        return result;
    }

    public static Legend createLegend(Node anchor, Legends legends) {
        Legend result = new Legend(legends);
        result.getFormats().setLineColor(anchor.getFormats().getLineColor());
        result.getFormats().setTextColor(anchor.getFormats().getTextColor());
        return result;
    }
}

